/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.spi.QueryId;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class LocalQueryProvider {
    private static final Logger log = Logger.get(LocalQueryProvider.class);
    private final QueryManager queryManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BoundedExecutor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"execution-query-purger"));

    @Inject
    public LocalQueryProvider(QueryManager queryManager, ExchangeClientSupplier exchangeClientSupplier, BlockEncodingSerde blockEncodingSerde, @ForStatementResource BoundedExecutor responseExecutor, @ForStatementResource ScheduledExecutorService timeoutExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
    }

    @PostConstruct
    public void start() {
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                for (Map.Entry entry : this.queries.entrySet()) {
                    try {
                        this.queryManager.getQueryState((QueryId)entry.getKey());
                    }
                    catch (NoSuchElementException e) {
                        this.queries.remove(entry.getKey());
                    }
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    public Query getQuery(QueryId queryId, String slug) {
        Session session;
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            return query;
        }
        try {
            if (!this.queryManager.isQuerySlugValid(queryId, slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            session = this.queryManager.getQuerySession(queryId);
        }
        catch (NoSuchElementException e) {
            throw LocalQueryProvider.notFound("Query not found");
        }
        query = this.queries.computeIfAbsent(queryId, id -> {
            ExchangeClient exchangeClient = this.exchangeClientSupplier.get((LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), LocalQueryProvider.class.getSimpleName()));
            return Query.create(session, slug, this.queryManager, exchangeClient, (Executor)this.responseExecutor, this.timeoutExecutor, this.blockEncodingSerde);
        });
        return query;
    }

    public void cancel(QueryId queryId, String slug) {
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            query.cancel();
        }
        try {
            if (!this.queryManager.isQuerySlugValid(queryId, slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            this.queryManager.cancelQuery(queryId);
        }
        catch (NoSuchElementException e) {
            throw LocalQueryProvider.notFound("Query not found");
        }
    }

    private static WebApplicationException notFound(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }
}

