/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Backoff {
    private static final int MIN_RETRIES = 3;
    private static final List<Duration> DEFAULT_BACKOFF_DELAY_INTERVALS = ImmutableList.builder().add((Object)new Duration(0.0, TimeUnit.MILLISECONDS)).add((Object)new Duration(50.0, TimeUnit.MILLISECONDS)).add((Object)new Duration(100.0, TimeUnit.MILLISECONDS)).add((Object)new Duration(200.0, TimeUnit.MILLISECONDS)).add((Object)new Duration(500.0, TimeUnit.MILLISECONDS)).build();
    private final int minTries;
    private final long maxFailureIntervalNanos;
    private final Ticker ticker;
    private final long[] backoffDelayIntervalsNanos;
    private long firstFailureTime;
    private long lastFailureTime;
    private long failureCount;
    private long failureRequestTimeTotal;
    private long lastRequestStart;

    public Backoff(Duration maxFailureInterval) {
        this(maxFailureInterval, Ticker.systemTicker());
    }

    public Backoff(Duration maxFailureInterval, Ticker ticker) {
        this(3, maxFailureInterval, ticker, DEFAULT_BACKOFF_DELAY_INTERVALS);
    }

    @VisibleForTesting
    public Backoff(int minTries, Duration maxFailureInterval, Ticker ticker, List<Duration> backoffDelayIntervals) {
        Preconditions.checkArgument((minTries > 0 ? 1 : 0) != 0, (Object)"minTries must be at least 1");
        Objects.requireNonNull(maxFailureInterval, "maxFailureInterval is null");
        Objects.requireNonNull(ticker, "ticker is null");
        Objects.requireNonNull(backoffDelayIntervals, "backoffDelayIntervals is null");
        Preconditions.checkArgument((!backoffDelayIntervals.isEmpty() ? 1 : 0) != 0, (Object)"backoffDelayIntervals must contain at least one entry");
        this.minTries = minTries;
        this.maxFailureIntervalNanos = maxFailureInterval.roundTo(TimeUnit.NANOSECONDS);
        this.ticker = ticker;
        this.backoffDelayIntervalsNanos = backoffDelayIntervals.stream().mapToLong(duration -> duration.roundTo(TimeUnit.NANOSECONDS)).toArray();
    }

    public synchronized long getFailureCount() {
        return this.failureCount;
    }

    public synchronized Duration getFailureDuration() {
        if (this.firstFailureTime == 0L) {
            return new Duration(0.0, TimeUnit.MILLISECONDS);
        }
        long value = this.ticker.read() - this.firstFailureTime;
        return new Duration((double)value, TimeUnit.NANOSECONDS);
    }

    public synchronized Duration getFailureRequestTimeTotal() {
        return new Duration((double)Math.max(0L, this.failureRequestTimeTotal), TimeUnit.NANOSECONDS);
    }

    public synchronized void startRequest() {
        this.lastRequestStart = this.ticker.read();
    }

    public synchronized void success() {
        this.lastRequestStart = 0L;
        this.firstFailureTime = 0L;
        this.failureCount = 0L;
        this.lastFailureTime = 0L;
    }

    public synchronized boolean failure() {
        long now;
        this.lastFailureTime = now = this.ticker.read();
        ++this.failureCount;
        if (this.lastRequestStart != 0L) {
            this.failureRequestTimeTotal += now - this.lastRequestStart;
            this.lastRequestStart = 0L;
        }
        if (this.firstFailureTime == 0L) {
            this.firstFailureTime = now;
            return false;
        }
        if (this.failureCount < (long)this.minTries) {
            return false;
        }
        long failureDuration = now - this.firstFailureTime;
        return failureDuration >= this.maxFailureIntervalNanos;
    }

    public synchronized long getBackoffDelayNanos() {
        int failureCount = (int)Math.min((long)this.backoffDelayIntervalsNanos.length, this.failureCount);
        if (failureCount == 0) {
            return 0L;
        }
        long currentDelay = this.backoffDelayIntervalsNanos[failureCount - 1];
        long nanosSinceLastFailure = this.ticker.read() - this.lastFailureTime;
        return Math.max(0L, currentDelay - nanosSinceLastFailure);
    }
}

