/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import java.util.List;
import java.util.Optional;

public class CoalesceCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Variable wasNull = generatorContext.wasNull();
        LabelNode endLabel = new LabelNode("end");
        BytecodeBlock block = new BytecodeBlock();
        for (RowExpression expression : arguments.subList(0, arguments.size() - 1)) {
            block.append(generatorContext.generate(expression, Optional.empty()));
            IfStatement ifStatement = new IfStatement().condition((BytecodeNode)wasNull);
            ifStatement.ifTrue().pop(returnType.getJavaType()).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
            ifStatement.ifFalse().gotoLabel(endLabel);
            block.append((BytecodeNode)ifStatement);
        }
        block.append(generatorContext.generate(arguments.get(arguments.size() - 1), Optional.empty()));
        block.visitLabel(endLabel);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }
}

