/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ExpressionVariableInliner {
    private final Function<VariableReferenceExpression, Expression> mapping;
    private final TypeProvider types;

    public static Expression inlineVariables(Map<VariableReferenceExpression, ? extends Expression> mapping, Expression expression, TypeProvider types) {
        return ExpressionVariableInliner.inlineVariables(mapping::get, expression, types);
    }

    public static Expression inlineVariables(Function<VariableReferenceExpression, Expression> mapping, Expression expression, TypeProvider types) {
        return new ExpressionVariableInliner(mapping, types).rewrite(expression);
    }

    private ExpressionVariableInliner(Function<VariableReferenceExpression, Expression> mapping, TypeProvider types) {
        this.mapping = mapping;
        this.types = types;
    }

    private Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private class Visitor
    extends ExpressionRewriter<Void> {
        private final Set<String> excludedNames = new HashSet<String>();

        private Visitor() {
        }

        public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.excludedNames.contains(node.getName())) {
                return node;
            }
            Expression expression = (Expression)ExpressionVariableInliner.this.mapping.apply(new VariableReferenceExpression(node.getName(), ExpressionVariableInliner.this.types.get((Expression)node)));
            Preconditions.checkState((expression != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
            return expression;
        }

        public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                String argumentName = argument.getName().getValue();
                Preconditions.checkArgument((!this.excludedNames.contains(argumentName) ? 1 : 0) != 0);
                this.excludedNames.add(argumentName);
            }
            Expression result = treeRewriter.defaultRewrite((Expression)node, (Object)context);
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                this.excludedNames.remove(argument.getName().getValue());
            }
            return result;
        }
    }
}

