/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import java.util.Collection;

public final class FragmentTableScanCounter {
    private FragmentTableScanCounter() {
    }

    public static int getNumberOfTableScans(Collection<PlanNode> nodes) {
        return FragmentTableScanCounter.getNumberOfTableScans(nodes.toArray(new PlanNode[0]));
    }

    public static boolean hasMultipleTableScans(PlanNode ... nodes) {
        return FragmentTableScanCounter.getNumberOfTableScans(nodes) > 1;
    }

    public static int getNumberOfTableScans(PlanNode ... nodes) {
        int count = 0;
        for (PlanNode node : nodes) {
            count += ((Integer)node.accept((PlanVisitor)new Visitor(), null)).intValue();
        }
        return count;
    }

    private static class Visitor
    extends InternalPlanVisitor<Integer, Void> {
        private Visitor() {
        }

        public Integer visitTableScan(TableScanNode node, Void context) {
            return 1;
        }

        @Override
        public Integer visitExchange(ExchangeNode node, Void context) {
            if (node.getScope().isRemote()) {
                return 0;
            }
            return this.visitPlan((PlanNode)node, context);
        }

        public Integer visitPlan(PlanNode node, Void context) {
            int count = 0;
            for (PlanNode source : node.getSources()) {
                count += ((Integer)source.accept((PlanVisitor)this, (Object)context)).intValue();
            }
            return count;
        }
    }
}

