/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class LazySplitSource
implements SplitSource {
    private final Supplier<SplitSource> supplier;
    @GuardedBy(value="this")
    private SplitSource delegate;
    @GuardedBy(value="this")
    private boolean closed;

    public LazySplitSource(Supplier<SplitSource> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
    }

    @Override
    public ConnectorId getConnectorId() {
        return this.getDelegate().getConnectorId();
    }

    @Override
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.getDelegate().getTransactionHandle();
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, Lifespan lifespan, int maxSize) {
        return this.getDelegate().getNextBatch(partitionHandle, lifespan, maxSize);
    }

    @Override
    public void rewind(ConnectorPartitionHandle partitionHandle) {
        this.getDelegate().rewind(partitionHandle);
    }

    @Override
    public boolean isFinished() {
        return this.getDelegate().isFinished();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.delegate == null) {
            return;
        }
        this.delegate.close();
    }

    private synchronized SplitSource getDelegate() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"split source is closed");
        if (this.delegate == null) {
            this.delegate = this.supplier.get();
        }
        return this.delegate;
    }
}

