/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class OutputPartitioning {
    private final PartitionFunction partitionFunction;
    private final List<Integer> partitionChannels;
    private final List<Optional<ConstantExpression>> partitionConstants;
    private final boolean replicateNullsAndAny;
    private final OptionalInt nullChannel;

    public OutputPartitioning(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicateNullsAndAny, OptionalInt nullChannel) {
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
        this.partitionConstants = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionConstants, "partitionConstants is null"));
        this.replicateNullsAndAny = replicateNullsAndAny;
        this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
    }

    public PartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    public List<Integer> getPartitionChannels() {
        return this.partitionChannels;
    }

    public List<Optional<ConstantExpression>> getPartitionConstants() {
        return this.partitionConstants;
    }

    public boolean isReplicateNullsAndAny() {
        return this.replicateNullsAndAny;
    }

    public OptionalInt getNullChannel() {
        return this.nullChannel;
    }
}

