/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitioningProviderManager {
    private final ConcurrentMap<ConnectorId, ConnectorNodePartitioningProvider> partitioningProviders = new ConcurrentHashMap<ConnectorId, ConnectorNodePartitioningProvider>();

    public ConnectorNodePartitioningProvider getPartitioningProvider(ConnectorId connectorId) {
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(connectorId);
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object)connectorId);
        return partitioningProvider;
    }

    public void addPartitioningProvider(ConnectorId connectorId, ConnectorNodePartitioningProvider nodePartitioningProvider) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        Preconditions.checkArgument((this.partitioningProviders.putIfAbsent(connectorId, nodePartitioningProvider) == null ? 1 : 0) != 0, (String)"NodePartitioningProvider for connector '%s' is already registered", (Object)connectorId);
    }

    public void removePartitioningProvider(ConnectorId connectorId) {
        this.partitioningProviders.remove(connectorId);
    }
}

