/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class RelationPlan {
    private final PlanNode root;
    private final List<VariableReferenceExpression> fieldMappings;
    private final Scope scope;

    public RelationPlan(PlanNode root, Scope scope, List<VariableReferenceExpression> fieldMappings) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(fieldMappings, "outputSymbols is null");
        Objects.requireNonNull(scope, "scope is null");
        int allFieldCount = RelationPlan.getAllFieldCount(scope);
        Preconditions.checkArgument((allFieldCount == fieldMappings.size() ? 1 : 0) != 0, (String)"Number of outputs (%s) doesn't match number of fields in scopes tree (%s)", (int)fieldMappings.size(), (int)allFieldCount);
        this.root = root;
        this.scope = scope;
        this.fieldMappings = ImmutableList.copyOf(fieldMappings);
    }

    public VariableReferenceExpression getVariable(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.fieldMappings.size() ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (int)fieldIndex);
        return this.fieldMappings.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<VariableReferenceExpression> getFieldMappings() {
        return this.fieldMappings;
    }

    public RelationType getDescriptor() {
        return this.scope.getRelationType();
    }

    public Scope getScope() {
        return this.scope;
    }

    private static int getAllFieldCount(Scope root) {
        int allFieldCount = 0;
        Optional<Scope> current = Optional.of(root);
        while (current.isPresent()) {
            allFieldCount += current.get().getRelationType().getAllFieldCount();
            current = current.get().getLocalParent();
        }
        return allFieldCount;
    }
}

