/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.pattern.TypeOfPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import java.util.stream.Stream;

public class RuleIndex {
    private final ListMultimap<Class<?>, Rule<?>> rulesByRootType;

    private RuleIndex(ListMultimap<Class<?>, Rule<?>> rulesByRootType) {
        this.rulesByRootType = ImmutableListMultimap.copyOf(rulesByRootType);
    }

    public Stream<Rule<?>> getCandidates(Object object) {
        return RuleIndex.supertypes(object.getClass()).flatMap(clazz -> this.rulesByRootType.get(clazz).stream());
    }

    private static Stream<Class<?>> supertypes(Class<?> type) {
        return TypeToken.of(type).getTypes().stream().map(TypeToken::getRawType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableListMultimap.Builder<Class<?>, Rule<?>> rulesByRootType = ImmutableListMultimap.builder();

        public Builder register(Set<Rule<?>> rules) {
            rules.forEach(this::register);
            return this;
        }

        public Builder register(Rule<?> rule) {
            Pattern<?> pattern = this.getFirstPattern(rule.getPattern());
            if (!(pattern instanceof TypeOfPattern)) {
                throw new IllegalArgumentException("Unexpected Pattern: " + pattern);
            }
            this.rulesByRootType.put((Object)((TypeOfPattern)pattern).expectedClass(), rule);
            return this;
        }

        private Pattern<?> getFirstPattern(Pattern<?> pattern) {
            while (pattern.previous() != null) {
                pattern = pattern.previous();
            }
            return pattern;
        }

        public RuleIndex build() {
            return new RuleIndex((ListMultimap)this.rulesByRootType.build());
        }
    }
}

