/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import com.facebook.presto.sql.relational.SqlFunctionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InlineSqlFunctions
extends ExpressionRewriteRuleSet {
    public InlineSqlFunctions(Metadata metadata, SqlParser sqlParser) {
        super(InlineSqlFunctions.createRewrite(metadata, sqlParser));
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(Metadata metadata, SqlParser sqlParser) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        return (expression, context) -> InlineSqlFunctionsRewriter.rewrite(expression, context.getSession(), metadata, ExpressionAnalyzer.getExpressionTypes(context.getSession(), metadata, sqlParser, context.getVariableAllocator().getTypes(), expression, Collections.emptyList(), context.getWarningCollector()));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite());
    }

    public static class InlineSqlFunctionsRewriter {
        private InlineSqlFunctionsRewriter() {
        }

        public static Expression rewrite(Expression expression, Session session, Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            if (SystemSessionProperties.isInlineSqlFunctions(session)) {
                return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, metadata, expressionTypes), (Expression)expression);
            }
            return expression;
        }

        private static class Visitor
        extends ExpressionRewriter<Void> {
            private final Session session;
            private final Metadata metadata;
            private final Map<NodeRef<Expression>, Type> expressionTypes;

            public Visitor(Session session, Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
                this.session = Objects.requireNonNull(session, "session is null");
                this.metadata = Objects.requireNonNull(metadata, "metadata is null");
                this.expressionTypes = expressionTypes;
            }

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                ArrayList<Type> argumentTypes = new ArrayList<Type>();
                ArrayList<Expression> rewrittenArguments = new ArrayList<Expression>();
                for (Expression argument : node.getArguments()) {
                    argumentTypes.add(this.expressionTypes.get(NodeRef.of((Node)argument)));
                    rewrittenArguments.add(treeRewriter.rewrite(argument, (Object)context));
                }
                FunctionHandle functionHandle = this.metadata.getFunctionAndTypeManager().resolveFunction(this.session.getTransactionId(), FunctionAndTypeManager.qualifyFunctionName(node.getName()), TypeSignatureProvider.fromTypes(argumentTypes));
                FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(functionHandle);
                if (functionMetadata.getImplementationType() != FunctionImplementationType.SQL) {
                    return new FunctionCall(node.getName(), rewrittenArguments);
                }
                return SqlFunctionUtils.getSqlFunctionExpression(functionMetadata, (SqlInvokedScalarFunctionImplementation)this.metadata.getFunctionAndTypeManager().getScalarFunctionImplementation(functionHandle), this.metadata, this.session.getSqlFunctionProperties(), rewrittenArguments);
            }
        }
    }
}

