/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;

public final class PushRemoteExchangeThroughAssignUniqueId
implements Rule<ExchangeNode> {
    private static final Capture<AssignUniqueId> ASSIGN_UNIQUE_ID = Capture.newCapture();
    private static final Pattern<ExchangeNode> PATTERN = Patterns.exchange().matching(exchange -> exchange.getScope().isRemote()).matching(exchange -> exchange.getType() != ExchangeNode.Type.REPLICATE).with(Patterns.source().matching(Patterns.assignUniqueId().capturedAs(ASSIGN_UNIQUE_ID)));

    @Override
    public Pattern<ExchangeNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExchangeNode node, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((!node.getOrderingScheme().isPresent() ? 1 : 0) != 0, (Object)"Merge exchange over AssignUniqueId not supported");
        AssignUniqueId assignUniqueId = (AssignUniqueId)((Object)captures.get(ASSIGN_UNIQUE_ID));
        PartitioningScheme partitioningScheme = node.getPartitioningScheme();
        if (partitioningScheme.getPartitioning().getVariableReferences().contains(assignUniqueId.getIdVariable())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AssignUniqueId(assignUniqueId.getId(), new ExchangeNode(node.getId(), node.getType(), node.getScope(), new PartitioningScheme(partitioningScheme.getPartitioning(), PushRemoteExchangeThroughAssignUniqueId.removeVariable(partitioningScheme.getOutputLayout(), assignUniqueId.getIdVariable()), partitioningScheme.getHashColumn(), partitioningScheme.isReplicateNullsAndAny(), partitioningScheme.getBucketToPartition()), (List<PlanNode>)ImmutableList.of((Object)assignUniqueId.getSource()), (List<List<VariableReferenceExpression>>)ImmutableList.of(PushRemoteExchangeThroughAssignUniqueId.removeVariable((List)Iterables.getOnlyElement(node.getInputs()), assignUniqueId.getIdVariable())), node.isEnsureSourceOrdering(), Optional.empty()), assignUniqueId.getIdVariable()));
    }

    private static List<VariableReferenceExpression> removeVariable(List<VariableReferenceExpression> variables, VariableReferenceExpression variableToRemove) {
        return (List)variables.stream().filter(variable -> !variableToRemove.equals(variable)).collect(ImmutableList.toImmutableList());
    }
}

