/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EnforceSingleRowNode
extends InternalPlanNode {
    private final PlanNode source;

    @JsonCreator
    public EnforceSingleRowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitEnforceSingleRow(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new EnforceSingleRowNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren));
    }
}

