/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LateralJoinNode
extends InternalPlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<VariableReferenceExpression> correlation;
    private final Type type;
    private final String originSubqueryError;

    @JsonCreator
    public LateralJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="correlation") List<VariableReferenceExpression> correlation, @JsonProperty(value="type") Type type, @JsonProperty(value="originSubqueryError") String originSubqueryError) {
        super(id);
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(subquery, "right is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(originSubqueryError, "originSubqueryError is null");
        Preconditions.checkArgument((boolean)input.getOutputVariables().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        this.input = input;
        this.subquery = subquery;
        this.correlation = ImmutableList.copyOf(correlation);
        this.type = type;
        this.originSubqueryError = originSubqueryError;
    }

    @JsonProperty
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getOriginSubqueryError() {
        return this.originSubqueryError;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.input.getOutputVariables()).addAll((Iterable)this.subquery.getOutputVariables()).build();
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new LateralJoinNode(this.getId(), newChildren.get(0), newChildren.get(1), this.correlation, this.type, this.originSubqueryError);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitLateralJoin(this, context);
    }

    public static enum Type {
        INNER(JoinNode.Type.INNER),
        LEFT(JoinNode.Type.LEFT);

        private final JoinNode.Type joinNodeType;

        private Type(JoinNode.Type joinNodeType) {
            this.joinNodeType = joinNodeType;
        }

        public JoinNode.Type toJoinNodeType() {
            return this.joinNodeType;
        }
    }
}

