/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.operator.WindowInfo;
import com.facebook.presto.util.Mergeable;
import com.google.common.base.Preconditions;

class WindowOperatorStats
implements Mergeable<WindowOperatorStats> {
    private final int activeDrivers;
    private final int totalDrivers;
    private final double positionsInIndexesSumSquaredDiffs;
    private final double sizeOfIndexesSumSquaredDiffs;
    private final double indexCountPerDriverSumSquaredDiffs;
    private final double partitionRowsSumSquaredDiffs;
    private final double rowCountPerDriverSumSquaredDiffs;
    private final long totalRowCount;
    private final long totalIndexesCount;
    private final long totalPartitionsCount;

    public static WindowOperatorStats create(WindowInfo info) {
        Preconditions.checkArgument((info.getWindowInfos().size() > 0 ? 1 : 0) != 0, (Object)"WindowInfo cannot have empty list of DriverWindowInfos");
        int activeDrivers = 0;
        int totalDrivers = 0;
        double partitionRowsSumSquaredDiffs = 0.0;
        double positionsInIndexesSumSquaredDiffs = 0.0;
        double sizeOfIndexesSumSquaredDiffs = 0.0;
        double indexCountPerDriverSumSquaredDiffs = 0.0;
        double rowCountPerDriverSumSquaredDiffs = 0.0;
        long totalRowCount = 0L;
        long totalIndexesCount = 0L;
        long totalPartitionsCount = 0L;
        double averageNumberOfIndexes = info.getWindowInfos().stream().filter(WindowOperatorStats::isMeaningful).mapToLong(WindowInfo.DriverWindowInfo::getNumberOfIndexes).average().orElse(Double.NaN);
        double averageNumberOfRows = info.getWindowInfos().stream().filter(WindowOperatorStats::isMeaningful).mapToLong(WindowInfo.DriverWindowInfo::getTotalRowsCount).average().orElse(Double.NaN);
        for (WindowInfo.DriverWindowInfo driverWindowInfo : info.getWindowInfos()) {
            long driverTotalRowsCount = driverWindowInfo.getTotalRowsCount();
            ++totalDrivers;
            if (driverTotalRowsCount <= 0L) continue;
            long numberOfIndexes = driverWindowInfo.getNumberOfIndexes();
            partitionRowsSumSquaredDiffs += driverWindowInfo.getSumSquaredDifferencesSizeInPartition();
            totalPartitionsCount += driverWindowInfo.getTotalPartitionsCount();
            totalRowCount += driverWindowInfo.getTotalRowsCount();
            positionsInIndexesSumSquaredDiffs += driverWindowInfo.getSumSquaredDifferencesPositionsOfIndex();
            sizeOfIndexesSumSquaredDiffs += driverWindowInfo.getSumSquaredDifferencesSizeOfIndex();
            totalIndexesCount += numberOfIndexes;
            indexCountPerDriverSumSquaredDiffs += Math.pow((double)numberOfIndexes - averageNumberOfIndexes, 2.0);
            rowCountPerDriverSumSquaredDiffs += Math.pow((double)driverTotalRowsCount - averageNumberOfRows, 2.0);
            ++activeDrivers;
        }
        return new WindowOperatorStats(partitionRowsSumSquaredDiffs, positionsInIndexesSumSquaredDiffs, sizeOfIndexesSumSquaredDiffs, indexCountPerDriverSumSquaredDiffs, rowCountPerDriverSumSquaredDiffs, totalRowCount, totalIndexesCount, totalPartitionsCount, activeDrivers, totalDrivers);
    }

    private static boolean isMeaningful(WindowInfo.DriverWindowInfo windowInfo) {
        return windowInfo.getTotalRowsCount() > 0L;
    }

    private WindowOperatorStats(double partitionRowsSumSquaredDiffs, double positionsInIndexesSumSquaredDiffs, double sizeOfIndexesSumSquaredDiffs, double indexCountPerDriverSumSquaredDiffs, double rowCountPerDriverSumSquaredDiffs, long totalRowCount, long totalIndexesCount, long totalPartitionsCount, int activeDrivers, int totalDrivers) {
        this.partitionRowsSumSquaredDiffs = partitionRowsSumSquaredDiffs;
        this.positionsInIndexesSumSquaredDiffs = positionsInIndexesSumSquaredDiffs;
        this.sizeOfIndexesSumSquaredDiffs = sizeOfIndexesSumSquaredDiffs;
        this.indexCountPerDriverSumSquaredDiffs = indexCountPerDriverSumSquaredDiffs;
        this.rowCountPerDriverSumSquaredDiffs = rowCountPerDriverSumSquaredDiffs;
        this.totalRowCount = totalRowCount;
        this.totalIndexesCount = totalIndexesCount;
        this.totalPartitionsCount = totalPartitionsCount;
        this.activeDrivers = activeDrivers;
        this.totalDrivers = totalDrivers;
    }

    @Override
    public WindowOperatorStats mergeWith(WindowOperatorStats other) {
        return new WindowOperatorStats(this.partitionRowsSumSquaredDiffs + other.partitionRowsSumSquaredDiffs, this.positionsInIndexesSumSquaredDiffs + other.positionsInIndexesSumSquaredDiffs, this.sizeOfIndexesSumSquaredDiffs + other.sizeOfIndexesSumSquaredDiffs, this.indexCountPerDriverSumSquaredDiffs + other.indexCountPerDriverSumSquaredDiffs, this.rowCountPerDriverSumSquaredDiffs + other.rowCountPerDriverSumSquaredDiffs, this.totalRowCount + other.totalRowCount, this.totalIndexesCount + other.totalIndexesCount, this.totalPartitionsCount + other.totalPartitionsCount, this.activeDrivers + other.activeDrivers, this.totalDrivers + other.totalDrivers);
    }

    public double getIndexSizeStdDev() {
        return Math.sqrt(this.sizeOfIndexesSumSquaredDiffs / (double)this.totalIndexesCount);
    }

    public double getIndexPositionsStdDev() {
        return Math.sqrt(this.positionsInIndexesSumSquaredDiffs / (double)this.totalIndexesCount);
    }

    public double getIndexCountPerDriverStdDev() {
        return Math.sqrt(this.indexCountPerDriverSumSquaredDiffs / (double)this.activeDrivers);
    }

    public double getPartitionRowsStdDev() {
        return Math.sqrt(this.partitionRowsSumSquaredDiffs / (double)this.totalPartitionsCount);
    }

    public double getRowsPerDriverStdDev() {
        return Math.sqrt(this.rowCountPerDriverSumSquaredDiffs / (double)this.activeDrivers);
    }

    public int getActiveDrivers() {
        return this.activeDrivers;
    }

    public int getTotalDrivers() {
        return this.totalDrivers;
    }
}

