/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class VerifyNoOriginalExpression
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        plan.accept((PlanVisitor)new Visitor(), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private Visitor() {
        }

        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getAssignments().getExpressions().forEach(Visitor::checkNotOriginalExpression);
            return null;
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getAggregations().values().forEach(Visitor::checkAggregation);
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getWindowFunctions().values().forEach(windowNodeFunction -> windowNodeFunction.getFunctionCall().getArguments().forEach(Visitor::checkNotOriginalExpression));
            return null;
        }

        public Void visitFilter(FilterNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            Visitor.checkNotOriginalExpression(node.getPredicate());
            return null;
        }

        public Void visitValues(ValuesNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getRows().forEach(rows -> rows.forEach(Visitor::checkNotOriginalExpression));
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getFilter().ifPresent(Visitor::checkNotOriginalExpression);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            Visitor.checkNotOriginalExpression(node.getFilter());
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getSubqueryAssignments().getExpressions().forEach(Visitor::checkNotOriginalExpression);
            return null;
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            Visitor.checkStatisticsAggregation(node.getStatisticsAggregation());
            return null;
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            Visitor.checkStatisticsAggregation(node.getStatisticsAggregation());
            return null;
        }

        @Override
        public Void visitTableWriteMerge(TableWriterMergeNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            Visitor.checkStatisticsAggregation(node.getStatisticsAggregation());
            return null;
        }

        private static void checkStatisticsAggregation(Optional<StatisticAggregations> statisticsAggregation) {
            statisticsAggregation.ifPresent(statisticAggregations -> statisticAggregations.getAggregations().values().forEach(Visitor::checkAggregation));
        }

        private static void checkAggregation(AggregationNode.Aggregation aggregation) {
            aggregation.getFilter().ifPresent(Visitor::checkNotOriginalExpression);
            aggregation.getArguments().forEach(Visitor::checkNotOriginalExpression);
        }

        private static void checkNotOriginalExpression(RowExpression expression) {
            Preconditions.checkArgument((!OriginalExpressionUtils.isExpression(expression) ? 1 : 0) != 0, (String)"Unexpected original expression %s", (Object)expression);
        }
    }
}

