/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tdigest;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Centroid
implements Comparable<Centroid>,
Serializable {
    private static final AtomicInteger uniqueCount = new AtomicInteger(1);
    private double centroid;
    private int count;
    private transient int id;

    public Centroid(double x) {
        this.start(x, 1, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, int w) {
        this.start(x, w, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, int w, int id) {
        this.start(x, w, id);
    }

    private void start(double x, int w, int id) {
        this.id = id;
        this.add(x, w);
    }

    public void add(double x, int w) {
        this.count += w;
        this.centroid += (double)w * (x - this.centroid) / (double)this.count;
    }

    public double getMean() {
        return this.centroid;
    }

    public int getWeight() {
        return this.count;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "Centroid{mean=" + this.centroid + ", count=" + this.count + '}';
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Centroid centroid = (Centroid)o;
        return this.centroid == centroid.getMean() && this.count == centroid.getWeight();
    }

    @Override
    public int compareTo(Centroid o) {
        Objects.requireNonNull(o);
        int r = Double.compare(this.centroid, o.centroid);
        if (r == 0) {
            r = this.id - o.id;
        }
        return r;
    }
}

