/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractIntType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.operator.scalar.ColorFunctions;

public class ColorType
extends AbstractIntType {
    public static final ColorType COLOR = new ColorType();
    public static final String NAME = "color";

    private ColorType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]));
    }

    public boolean isOrderable() {
        return false;
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException();
    }

    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int color = block.getInt(position);
        if (color < 0) {
            return ColorFunctions.SystemColor.valueOf(-(color + 1)).getName();
        }
        return String.format("#%02x%02x%02x", color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public boolean equals(Object other) {
        return other == COLOR;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

