/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.common.type.LongEnumType;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.XxHash64;

public final class LongEnumOperators {
    private LongEnumOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="T") long left, @SqlType(value="T") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="T") long left, @SqlType(value="T") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="T") long left, @IsNull boolean leftNull, @SqlType(value="T") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return LongEnumOperators.notEqual(left, right);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="T") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="T") long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="T") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="T") long left, @SqlType(value="T") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="T") long left, @SqlType(value="T") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="T") long left, @SqlType(value="T") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="T") long left, @SqlType(value="T") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @TypeParameter(value="T", boundedBy=LongEnumType.class)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="T") long value, @SqlType(value="T") long min, @SqlType(value="T") long max) {
        return min <= value && value <= max;
    }
}

