/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.LongStream;
import org.openjdk.jol.info.ClassLayout;

public class KHyperLogLog {
    public static final int DEFAULT_HLL_BUCKETS = 256;
    public static final int DEFAULT_MAX_SIZE = 4096;
    public static final long DEFAULT_HISTOGRAM_SIZE = 256L;
    private static final byte VERSION_BYTE = 1;
    private static final long HASH_OUTPUT_HALF_RANGE = Long.MAX_VALUE;
    private static final int SIZE_OF_KHYPERLOGLOG = ClassLayout.parseClass(KHyperLogLog.class).instanceSize();
    private static final int SIZE_OF_RBTREEMAP = ClassLayout.parseClass(Long2ObjectRBTreeMap.class).instanceSize();
    private final Long2ObjectSortedMap<HyperLogLog> minhash;
    private final int maxSize;
    private final int hllBuckets;
    private int hllsTotalEstimatedInMemorySize;
    private int hllsTotalEstimatedSerializedSize;

    public KHyperLogLog() {
        this(4096, 256, (Long2ObjectSortedMap<HyperLogLog>)new Long2ObjectRBTreeMap());
    }

    public KHyperLogLog(int maxSize, int hllBuckets) {
        this(maxSize, hllBuckets, (Long2ObjectSortedMap<HyperLogLog>)new Long2ObjectRBTreeMap());
    }

    public KHyperLogLog(int maxSize, int hllBuckets, Long2ObjectSortedMap<HyperLogLog> minhash) {
        this.maxSize = maxSize;
        this.hllBuckets = hllBuckets;
        this.minhash = Objects.requireNonNull(minhash, "minhash is null");
        minhash.values().forEach(this::increaseTotalHllSize);
    }

    public static KHyperLogLog newInstance(Slice serialized) {
        Objects.requireNonNull(serialized, "serialized is null");
        BasicSliceInput input = serialized.getInput();
        Preconditions.checkArgument((input.readByte() == 1 ? 1 : 0) != 0, (Object)"Unexpected version");
        Long2ObjectRBTreeMap minhash = new Long2ObjectRBTreeMap();
        int maxSize = input.readInt();
        int hllBuckets = input.readInt();
        int minhashSize = input.readInt();
        int totalHllSize = input.readInt();
        int[] hllSizes = new int[minhashSize];
        long[] keys = new long[minhashSize];
        input.readBytes(Slices.wrappedIntArray((int[])hllSizes));
        input.readBytes(Slices.wrappedLongArray((long[])keys));
        Slice allSerializedHlls = input.readSlice(totalHllSize);
        int index = 0;
        for (int i = 0; i < minhashSize; ++i) {
            int hllLength = hllSizes[i];
            Slice serializedHll = allSerializedHlls.slice(index, hllLength);
            index += hllLength;
            minhash.put(keys[i], (Object)HyperLogLog.newInstance((Slice)serializedHll));
        }
        return new KHyperLogLog(maxSize, hllBuckets, (Long2ObjectSortedMap<HyperLogLog>)minhash);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Slice serialize() {
        try (DynamicSliceOutput output = new DynamicSliceOutput(this.estimatedSerializedSize());){
            ArrayList<Slice> hllSlices = new ArrayList<Slice>();
            IntArrayList hllSizes = new IntArrayList();
            int totalHllSize = 0;
            for (HyperLogLog hll : this.minhash.values()) {
                Slice serializedHll = hll.serialize();
                hllSlices.add(serializedHll);
                totalHllSize += serializedHll.length();
                hllSizes.add(serializedHll.length());
            }
            Slice hashesSlice = Slices.wrappedLongArray((long[])this.minhash.keySet().toLongArray());
            Slice hllSizesSlice = Slices.wrappedIntArray((int[])hllSizes.toIntArray());
            output.appendByte(1);
            output.appendInt(this.maxSize);
            output.appendInt(this.hllBuckets);
            output.appendInt(this.minhash.size());
            output.appendInt(totalHllSize);
            output.appendBytes(hllSizesSlice);
            output.appendBytes(hashesSlice);
            for (Slice hllSlice : hllSlices) {
                output.appendBytes(hllSlice);
            }
            Slice slice = output.slice();
            return slice;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long exactIntersectionCardinality(KHyperLogLog a, KHyperLogLog b) {
        Preconditions.checkState((boolean)a.isExact(), (Object)"exact intersection cannot operate on approximate sets");
        Preconditions.checkArgument((boolean)b.isExact(), (Object)"exact intersection cannot operate on approximate sets");
        return Sets.intersection((Set)a.minhash.keySet(), (Set)b.minhash.keySet()).size();
    }

    public static double jaccardIndex(KHyperLogLog a, KHyperLogLog b) {
        int sizeOfSmallerSet = Math.min(a.minhash.size(), b.minhash.size());
        LongRBTreeSet minUnion = new LongRBTreeSet(a.minhash.keySet());
        minUnion.addAll((LongCollection)b.minhash.keySet());
        int intersection = 0;
        int i = 0;
        LongBidirectionalIterator iterator = minUnion.iterator();
        while (iterator.hasNext()) {
            long key = iterator.nextLong();
            if (a.minhash.containsKey(key) && b.minhash.containsKey(key)) {
                ++intersection;
            }
            if (++i < sizeOfSmallerSet) continue;
            break;
        }
        return (double)intersection / (double)sizeOfSmallerSet;
    }

    public static KHyperLogLog merge(KHyperLogLog khll1, KHyperLogLog khll2) {
        if (khll1.maxSize <= khll2.maxSize) {
            return khll1.mergeWith(khll2);
        }
        return khll2.mergeWith(khll1);
    }

    public boolean isExact() {
        return this.minhash.size() < this.maxSize;
    }

    public long getMinhashSize() {
        return this.minhash.size();
    }

    public int estimatedInMemorySize() {
        return SIZE_OF_KHYPERLOGLOG + SIZE_OF_RBTREEMAP + this.minhash.size() * 8 + this.hllsTotalEstimatedInMemorySize * 1;
    }

    public int estimatedSerializedSize() {
        return 17 + this.minhash.size() * 12 + this.hllsTotalEstimatedSerializedSize * 1;
    }

    public void add(long value, long uii) {
        this.update(Murmur3Hash128.hash64((long)value), uii);
    }

    public void add(Slice value, long uii) {
        this.update(Murmur3Hash128.hash64((Slice)value), uii);
    }

    private void update(long hash, long uii) {
        if (!this.minhash.containsKey(hash) && !this.isExact() && hash >= this.minhash.lastLongKey()) {
            return;
        }
        HyperLogLog hll = (HyperLogLog)this.minhash.computeIfAbsent((Object)hash, k -> {
            HyperLogLog newHll = HyperLogLog.newInstance((int)this.hllBuckets);
            this.increaseTotalHllSize(newHll);
            return newHll;
        });
        this.decreaseTotalHllSize(hll);
        hll.add(uii);
        this.increaseTotalHllSize(hll);
        this.removeOverflowEntries();
    }

    public long cardinality() {
        if (this.isExact()) {
            return this.minhash.size();
        }
        long hashesRange = this.minhash.lastLongKey() - Long.MIN_VALUE;
        double halfDensity = (double)Long.divideUnsigned(hashesRange, this.minhash.size() - 1) / 2.0;
        return (long)(9.223372036854776E18 / halfDensity);
    }

    public KHyperLogLog mergeWith(KHyperLogLog other) {
        LongBidirectionalIterator iterator = other.minhash.keySet().iterator();
        while (iterator.hasNext()) {
            long key = iterator.nextLong();
            HyperLogLog thisHll = (HyperLogLog)this.minhash.get(key);
            HyperLogLog otherHll = (HyperLogLog)other.minhash.get(key);
            if (this.minhash.containsKey(key)) {
                this.decreaseTotalHllSize(thisHll);
                thisHll.mergeWith(otherHll);
                this.increaseTotalHllSize(thisHll);
                continue;
            }
            this.minhash.put(key, (Object)otherHll);
            this.increaseTotalHllSize(otherHll);
        }
        this.removeOverflowEntries();
        return this;
    }

    public double reidentificationPotential(long threshold) {
        long highlyUniqueValues = this.minhash.values().stream().map(HyperLogLog::cardinality).filter(cardinality -> cardinality <= threshold).count();
        return (double)highlyUniqueValues / (double)this.minhash.size();
    }

    public Long2DoubleMap uniquenessDistribution() {
        return this.uniquenessDistribution(256L);
    }

    public Long2DoubleMap uniquenessDistribution(long histogramSize) {
        Long2DoubleOpenHashMap out = new Long2DoubleOpenHashMap();
        PrimitiveIterator.OfLong iterator = LongStream.rangeClosed(1L, histogramSize).iterator();
        while (iterator.hasNext()) {
            out.put(iterator.nextLong(), 0.0);
        }
        int size = this.minhash.size();
        for (HyperLogLog hll : this.minhash.values()) {
            long bucket = Math.min(hll.cardinality(), histogramSize);
            out.merge((Object)bucket, (Object)(1.0 / (double)size), Double::sum);
        }
        return out;
    }

    private void removeOverflowEntries() {
        while (this.minhash.size() > this.maxSize) {
            HyperLogLog hll = (HyperLogLog)this.minhash.remove(this.minhash.lastLongKey());
            this.decreaseTotalHllSize(hll);
        }
    }

    private void decreaseTotalHllSize(HyperLogLog hll) {
        this.hllsTotalEstimatedInMemorySize -= hll.estimatedInMemorySize();
        this.hllsTotalEstimatedSerializedSize -= hll.estimatedSerializedSize();
    }

    private void increaseTotalHllSize(HyperLogLog hll) {
        this.hllsTotalEstimatedInMemorySize += hll.estimatedInMemorySize();
        this.hllsTotalEstimatedSerializedSize += hll.estimatedSerializedSize();
    }
}

