/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.SingleRowBlockWriter;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.BooleanOperators;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.VarcharOperators;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.JsonCastException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public final class JsonUtil {
    public static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final ObjectMapper OBJECT_MAPPED_UNORDERED = new ObjectMapper(JSON_FACTORY);
    private static final int MAX_JSON_LENGTH_IN_ERROR_MESSAGE = 10000;

    private JsonUtil() {
    }

    public static JsonParser createJsonParser(JsonFactory factory, Slice json) throws IOException {
        return factory.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }

    public static JsonGenerator createJsonGenerator(JsonFactory factory, SliceOutput output) throws IOException {
        return factory.createGenerator((OutputStream)output);
    }

    public static String truncateIfNecessaryForErrorMessage(Slice json) {
        if (json.length() <= 10000) {
            return json.toStringUtf8();
        }
        return json.slice(0, 10000).toStringUtf8() + "...(truncated)";
    }

    public static boolean canCastToJson(Type type) {
        String baseType = type.getTypeSignature().getBase();
        if (baseType.equals("unknown") || baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("real") || baseType.equals("double") || baseType.equals("decimal") || baseType.equals("varchar") || baseType.equals("json") || baseType.equals("timestamp") || baseType.equals("date")) {
            return true;
        }
        if (type instanceof EnumType) {
            return true;
        }
        if (type instanceof ArrayType) {
            return JsonUtil.canCastToJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return (mapType.getKeyType().getTypeSignature().getBase().equals("unknown") || JsonUtil.isValidJsonObjectKeyType(mapType.getKeyType())) && JsonUtil.canCastToJson(mapType.getValueType());
        }
        if (type instanceof RowType) {
            return type.getTypeParameters().stream().allMatch(JsonUtil::canCastToJson);
        }
        return false;
    }

    public static boolean canCastFromJson(Type type) {
        TypeSignature signature = type.getTypeSignature();
        String baseType = signature.getBase();
        if (signature.isEnum()) {
            return true;
        }
        if (baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("real") || baseType.equals("double") || baseType.equals("varchar") || baseType.equals("decimal") || baseType.equals("json")) {
            return true;
        }
        if (type instanceof ArrayType) {
            return JsonUtil.canCastFromJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return JsonUtil.isValidJsonObjectKeyType(((MapType)type).getKeyType()) && JsonUtil.canCastFromJson(((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            return type.getTypeParameters().stream().allMatch(JsonUtil::canCastFromJson);
        }
        return false;
    }

    private static boolean isValidJsonObjectKeyType(Type type) {
        String baseType = type.getTypeSignature().getBase();
        return baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("real") || baseType.equals("double") || baseType.equals("decimal") || baseType.equals("varchar") || type.getTypeSignature().isEnum();
    }

    public static Slice currentTokenAsVarchar(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return Slices.utf8Slice((String)parser.getText());
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToVarchar(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return Slices.utf8Slice((String)parser.getText());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToVarchar(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToVarchar(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "varchar", parser.getText()));
    }

    public static Long currentTokenAsBigint(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToBigint(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToLong(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return parser.getLongValue();
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToBigint(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToBigint(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "bigint", parser.getText()));
    }

    public static Long currentTokenAsInteger(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToInteger(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToInteger(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return Math.toIntExact(parser.getLongValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToInteger(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToInteger(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "integer", parser.getText()));
    }

    public static Long currentTokenAsSmallint(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToSmallint(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToSmallint(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return Shorts.checkedCast((long)parser.getLongValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToSmallint(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToSmallint(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "smallint", parser.getText()));
    }

    public static Long currentTokenAsTinyint(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToTinyint(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToTinyint(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return SignedBytes.checkedCast((long)parser.getLongValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToTinyint(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToTinyint(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "tinyint", parser.getText()));
    }

    public static Double currentTokenAsDouble(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToDouble(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return parser.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return parser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToDouble(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToDouble(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "double", parser.getText()));
    }

    public static Long currentTokenAsReal(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToFloat(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return Float.floatToRawIntBits(parser.getFloatValue());
            }
            case VALUE_NUMBER_INT: {
                return Float.floatToRawIntBits(parser.getFloatValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToReal(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToReal(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "real", parser.getText()));
    }

    public static Boolean currentTokenAsBoolean(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToBoolean(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToBoolean(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return BigintOperators.castToBoolean(parser.getLongValue());
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "boolean", parser.getText()));
    }

    public static Long currentTokenAsShortDecimal(JsonParser parser, int precision, int scale) throws IOException {
        BigDecimal bigDecimal = JsonUtil.currentTokenAsJavaDecimal(parser, precision, scale);
        return bigDecimal != null ? Long.valueOf(bigDecimal.unscaledValue().longValue()) : null;
    }

    public static Slice currentTokenAsLongDecimal(JsonParser parser, int precision, int scale) throws IOException {
        BigDecimal bigDecimal = JsonUtil.currentTokenAsJavaDecimal(parser, precision, scale);
        if (bigDecimal == null) {
            return null;
        }
        return Decimals.encodeUnscaledValue((BigInteger)bigDecimal.unscaledValue());
    }

    private static BigDecimal currentTokenAsJavaDecimal(JsonParser parser, int precision, int scale) throws IOException {
        BigDecimal result;
        switch (parser.getCurrentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                result = new BigDecimal(parser.getText());
                result = result.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                result = parser.getDecimalValue();
                result = result.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case VALUE_TRUE: {
                result = BigDecimal.ONE.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case VALUE_FALSE: {
                result = BigDecimal.ZERO.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            default: {
                throw new JsonCastException(String.format("Unexpected token when cast to DECIMAL(%s,%s): %s", precision, scale, parser.getText()));
            }
        }
        if (result.precision() > precision) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast input json to DECIMAL(%s,%s)", precision, scale));
        }
        return result;
    }

    public static Optional<Map<String, Integer>> getFieldNameToIndex(List<RowType.Field> rowFields) {
        if (!rowFields.get(0).getName().isPresent()) {
            return Optional.empty();
        }
        HashMap fieldNameToIndex = new HashMap(rowFields.size());
        for (int i = 0; i < rowFields.size(); ++i) {
            fieldNameToIndex.put(rowFields.get(i).getName().get(), i);
        }
        return Optional.of(fieldNameToIndex);
    }

    public static void parseJsonToSingleRowBlock(JsonParser parser, SingleRowBlockWriter singleRowBlockWriter, BlockBuilderAppender[] fieldAppenders, Optional<Map<String, Integer>> fieldNameToIndex) throws IOException {
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            for (int i = 0; i < fieldAppenders.length; ++i) {
                parser.nextToken();
                fieldAppenders[i].append(parser, (BlockBuilder)singleRowBlockWriter);
            }
            if (parser.nextToken() != JsonToken.END_ARRAY) {
                throw new JsonCastException(String.format("Expected json array ending, but got %s", parser.getText()));
            }
        } else {
            Verify.verify((parser.getCurrentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0);
            if (!fieldNameToIndex.isPresent()) {
                throw new JsonCastException("Cannot cast a JSON object to anonymous row type. Input must be a JSON array.");
            }
            boolean[] fieldWritten = new boolean[fieldAppenders.length];
            int numFieldsWritten = 0;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.currentToken() != JsonToken.FIELD_NAME) {
                    throw new JsonCastException(String.format("Expected a json field name, but got %s", parser.getText()));
                }
                String fieldName = parser.getText().toLowerCase(Locale.ENGLISH);
                Integer fieldIndex = fieldNameToIndex.get().get(fieldName);
                parser.nextToken();
                if (fieldIndex != null) {
                    if (fieldWritten[fieldIndex]) {
                        throw new JsonCastException("Duplicate field: " + fieldName);
                    }
                    fieldWritten[fieldIndex.intValue()] = true;
                    ++numFieldsWritten;
                    fieldAppenders[fieldIndex].append(parser, singleRowBlockWriter.getFieldBlockBuilder(fieldIndex.intValue()));
                    continue;
                }
                parser.skipChildren();
            }
            if (numFieldsWritten != fieldAppenders.length) {
                for (int i = 0; i < fieldWritten.length; ++i) {
                    if (fieldWritten[i]) continue;
                    singleRowBlockWriter.getFieldBlockBuilder(i).appendNull();
                }
            }
        }
    }

    public static class HashTable {
        private static final int EXPECTED_ENTRIES = 20;
        private static final float FILL_RATIO = 0.75f;
        private static final int EMPTY_SLOT = -1;
        private final Type type;
        private final BlockBuilder block;
        private int[] positionByHash;
        private int hashCapacity;
        private int maxFill;
        private int hashMask;
        private int size;

        public HashTable(Type type, BlockBuilder block) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.block = Objects.requireNonNull(block, "block is null");
            this.hashCapacity = HashCommon.arraySize((int)20, (float)0.75f);
            this.maxFill = HashTable.calculateMaxFill(this.hashCapacity);
            this.hashMask = this.hashCapacity - 1;
            this.positionByHash = new int[this.hashCapacity];
            Arrays.fill(this.positionByHash, -1);
        }

        public boolean contains(int position) {
            Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position is negative");
            return this.positionByHash[this.getHashPosition(position)] != -1;
        }

        public boolean addIfAbsent(int position) {
            Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position is negative");
            int hashPosition = this.getHashPosition(position);
            if (this.positionByHash[hashPosition] == -1) {
                this.positionByHash[hashPosition] = position;
                ++this.size;
                if (this.size >= this.maxFill) {
                    this.rehash();
                }
                return true;
            }
            return false;
        }

        private int getHashPosition(int position) {
            int hashPosition = this.getMaskedHash(TypeUtils.hashPosition(this.type, (Block)this.block, position));
            while (this.positionByHash[hashPosition] != -1) {
                if (TypeUtils.positionEqualsPosition(this.type, (Block)this.block, this.positionByHash[hashPosition], (Block)this.block, position)) {
                    return hashPosition;
                }
                hashPosition = this.getMaskedHash(hashPosition + 1);
            }
            return hashPosition;
        }

        private void rehash() {
            int newCapacity;
            long newCapacityLong = (long)this.hashCapacity * 2L;
            if (newCapacityLong > Integer.MAX_VALUE) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
            }
            this.hashCapacity = newCapacity = (int)newCapacityLong;
            this.hashMask = newCapacity - 1;
            this.maxFill = HashTable.calculateMaxFill(newCapacity);
            int[] oldPositionByHash = this.positionByHash;
            this.positionByHash = new int[newCapacity];
            Arrays.fill(this.positionByHash, -1);
            for (int position : oldPositionByHash) {
                if (position == -1) continue;
                this.positionByHash[this.getHashPosition((int)position)] = position;
            }
        }

        private static int calculateMaxFill(int hashSize) {
            Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
            int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
            if (maxFill == hashSize) {
                --maxFill;
            }
            Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
            return maxFill;
        }

        private int getMaskedHash(long rawHash) {
            return (int)(rawHash & (long)this.hashMask);
        }
    }

    private static class RowBlockBuilderAppender
    implements BlockBuilderAppender {
        final BlockBuilderAppender[] fieldAppenders;
        final Optional<Map<String, Integer>> fieldNameToIndex;

        RowBlockBuilderAppender(BlockBuilderAppender[] fieldAppenders, Optional<Map<String, Integer>> fieldNameToIndex) {
            this.fieldAppenders = fieldAppenders;
            this.fieldNameToIndex = fieldNameToIndex;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                blockBuilder.appendNull();
                return;
            }
            if (parser.getCurrentToken() != JsonToken.START_ARRAY && parser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json array or object, but got %s", parser.getText()));
            }
            JsonUtil.parseJsonToSingleRowBlock(parser, (SingleRowBlockWriter)blockBuilder.beginBlockEntry(), this.fieldAppenders, this.fieldNameToIndex);
            blockBuilder.closeEntry();
        }
    }

    private static class MapBlockBuilderAppender
    implements BlockBuilderAppender {
        final BlockBuilderAppender keyAppender;
        final BlockBuilderAppender valueAppender;
        final Type keyType;

        MapBlockBuilderAppender(BlockBuilderAppender keyAppender, BlockBuilderAppender valueAppender, Type keyType) {
            this.keyAppender = keyAppender;
            this.valueAppender = valueAppender;
            this.keyType = keyType;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                blockBuilder.appendNull();
                return;
            }
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json object, but got %s", parser.getText()));
            }
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            HashTable entryBuilderHashTable = new HashTable(this.keyType, entryBuilder);
            int position = 0;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                this.keyAppender.append(parser, entryBuilder);
                parser.nextToken();
                this.valueAppender.append(parser, entryBuilder);
                if (!entryBuilderHashTable.addIfAbsent(position)) {
                    throw new JsonCastException("Duplicate keys are not allowed");
                }
                position += 2;
            }
            blockBuilder.closeEntry();
        }
    }

    private static class ArrayBlockBuilderAppender
    implements BlockBuilderAppender {
        final BlockBuilderAppender elementAppender;

        ArrayBlockBuilderAppender(BlockBuilderAppender elementAppender) {
            this.elementAppender = elementAppender;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                blockBuilder.appendNull();
                return;
            }
            if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
                throw new JsonCastException(String.format("Expected a json array, but got %s", parser.getText()));
            }
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                this.elementAppender.append(parser, entryBuilder);
            }
            blockBuilder.closeEntry();
        }
    }

    private static class VarcharBlockBuilderAppender
    implements BlockBuilderAppender {
        final Type type;

        VarcharBlockBuilderAppender(Type type) {
            this.type = type;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Slice result = JsonUtil.currentTokenAsVarchar(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                this.type.writeSlice(blockBuilder, result);
            }
        }
    }

    private static class LongDecimalBlockBuilderAppender
    implements BlockBuilderAppender {
        final DecimalType type;

        LongDecimalBlockBuilderAppender(DecimalType type) {
            this.type = type;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Slice result = JsonUtil.currentTokenAsLongDecimal(parser, this.type.getPrecision(), this.type.getScale());
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                this.type.writeSlice(blockBuilder, result);
            }
        }
    }

    private static class ShortDecimalBlockBuilderAppender
    implements BlockBuilderAppender {
        final DecimalType type;

        ShortDecimalBlockBuilderAppender(DecimalType type) {
            this.type = type;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsShortDecimal(parser, this.type.getPrecision(), this.type.getScale());
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                this.type.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class DoubleBlockBuilderAppender
    implements BlockBuilderAppender {
        private DoubleBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Double result = JsonUtil.currentTokenAsDouble(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(blockBuilder, result.doubleValue());
            }
        }
    }

    private static class RealBlockBuilderAppender
    implements BlockBuilderAppender {
        private RealBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsReal(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                RealType.REAL.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class BigintBlockBuilderAppender
    implements BlockBuilderAppender {
        private BigintBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsBigint(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class IntegerBlockBuilderAppender
    implements BlockBuilderAppender {
        private IntegerBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsInteger(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                IntegerType.INTEGER.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class SmallintBlockBuilderAppender
    implements BlockBuilderAppender {
        private SmallintBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsInteger(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                SmallintType.SMALLINT.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class TinyintBlockBuilderAppender
    implements BlockBuilderAppender {
        private TinyintBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsTinyint(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                TinyintType.TINYINT.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class BooleanBlockBuilderAppender
    implements BlockBuilderAppender {
        private BooleanBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Boolean result = JsonUtil.currentTokenAsBoolean(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, result.booleanValue());
            }
        }
    }

    public static interface BlockBuilderAppender {
        public void append(JsonParser var1, BlockBuilder var2) throws IOException;

        public static BlockBuilderAppender createBlockBuilderAppender(Type type) {
            TypeSignature signature = type.getTypeSignature();
            String baseType = signature.getBase();
            if (signature.isLongEnum()) {
                return new BigintBlockBuilderAppender();
            }
            if (signature.isVarcharEnum()) {
                return new VarcharBlockBuilderAppender(type);
            }
            switch (baseType) {
                case "boolean": {
                    return new BooleanBlockBuilderAppender();
                }
                case "tinyint": {
                    return new TinyintBlockBuilderAppender();
                }
                case "smallint": {
                    return new SmallintBlockBuilderAppender();
                }
                case "integer": {
                    return new IntegerBlockBuilderAppender();
                }
                case "bigint": {
                    return new BigintBlockBuilderAppender();
                }
                case "real": {
                    return new RealBlockBuilderAppender();
                }
                case "double": {
                    return new DoubleBlockBuilderAppender();
                }
                case "decimal": {
                    if (Decimals.isShortDecimal((Type)type)) {
                        return new ShortDecimalBlockBuilderAppender((DecimalType)type);
                    }
                    return new LongDecimalBlockBuilderAppender((DecimalType)type);
                }
                case "varchar": {
                    return new VarcharBlockBuilderAppender(type);
                }
                case "json": {
                    return (parser, blockBuilder) -> {
                        String json = OBJECT_MAPPED_UNORDERED.writeValueAsString((Object)parser.readValueAsTree());
                        JsonType.JSON.writeSlice(blockBuilder, Slices.utf8Slice((String)json));
                    };
                }
                case "array": {
                    return new ArrayBlockBuilderAppender(BlockBuilderAppender.createBlockBuilderAppender(((ArrayType)type).getElementType()));
                }
                case "map": {
                    MapType mapType = (MapType)type;
                    return new MapBlockBuilderAppender(BlockBuilderAppender.createBlockBuilderAppender(mapType.getKeyType()), BlockBuilderAppender.createBlockBuilderAppender(mapType.getValueType()), mapType.getKeyType());
                }
                case "row": {
                    RowType rowType = (RowType)type;
                    List rowFields = rowType.getFields();
                    BlockBuilderAppender[] fieldAppenders = new BlockBuilderAppender[rowFields.size()];
                    for (int i = 0; i < fieldAppenders.length; ++i) {
                        fieldAppenders[i] = BlockBuilderAppender.createBlockBuilderAppender(((RowType.Field)rowFields.get(i)).getType());
                    }
                    return new RowBlockBuilderAppender(fieldAppenders, JsonUtil.getFieldNameToIndex(rowFields));
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }

    private static class RowJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final RowType type;
        private final List<JsonGeneratorWriter> fieldWriters;

        public RowJsonGeneratorWriter(RowType type, List<JsonGeneratorWriter> fieldWriters) {
            this.type = type;
            this.fieldWriters = fieldWriters;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block rowBlock = this.type.getObject(block, position);
                jsonGenerator.writeStartArray();
                for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                    this.fieldWriters.get(i).writeJsonValue(jsonGenerator, rowBlock, i, properties);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }

    private static class MapJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final MapType type;
        private final ObjectKeyProvider keyProvider;
        private final JsonGeneratorWriter valueWriter;

        public MapJsonGeneratorWriter(MapType type, ObjectKeyProvider keyProvider, JsonGeneratorWriter valueWriter) {
            this.type = type;
            this.keyProvider = keyProvider;
            this.valueWriter = valueWriter;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block mapBlock = this.type.getObject(block, position);
                TreeMap<String, Integer> orderedKeyToValuePosition = new TreeMap<String, Integer>();
                for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                    String objectKey = this.keyProvider.getObjectKey(mapBlock, i);
                    orderedKeyToValuePosition.put(objectKey, i + 1);
                }
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : orderedKeyToValuePosition.entrySet()) {
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    this.valueWriter.writeJsonValue(jsonGenerator, mapBlock, (Integer)entry.getValue(), properties);
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    private static class ArrayJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final ArrayType type;
        private final JsonGeneratorWriter elementWriter;

        public ArrayJsonGeneratorWriter(ArrayType type, JsonGeneratorWriter elementWriter) {
            this.type = type;
            this.elementWriter = elementWriter;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block arrayBlock = this.type.getObject(block, position);
                jsonGenerator.writeStartArray();
                for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                    this.elementWriter.writeJsonValue(jsonGenerator, arrayBlock, i, properties);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }

    private static class DateGeneratorWriter
    implements JsonGeneratorWriter {
        private DateGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = DateType.DATE.getLong(block, position);
                jsonGenerator.writeString(DateTimeUtils.printDate((int)value));
            }
        }
    }

    private static class TimestampJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private TimestampJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = TimestampType.TIMESTAMP.getLong(block, position);
                jsonGenerator.writeString(DateTimeUtils.printTimestampWithoutTimeZone(properties.getTimeZoneKey(), value));
            }
        }
    }

    private static class JsonJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private JsonJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Slice value = JsonType.JSON.getSlice(block, position);
                jsonGenerator.writeRawValue(value.toStringUtf8());
            }
        }
    }

    private static class VarcharJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final Type type;

        public VarcharJsonGeneratorWriter(Type type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Slice value = this.type.getSlice(block, position);
                jsonGenerator.writeString(value.toStringUtf8());
            }
        }
    }

    private static class LongDeicmalJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final DecimalType type;

        public LongDeicmalJsonGeneratorWriter(DecimalType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                BigDecimal value = new BigDecimal(Decimals.decodeUnscaledValue((Slice)this.type.getSlice(block, position)), this.type.getScale());
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class ShortDecimalJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final DecimalType type;

        public ShortDecimalJsonGeneratorWriter(DecimalType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                BigDecimal value = BigDecimal.valueOf(this.type.getLong(block, position), this.type.getScale());
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class DoubleJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private DoubleJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                double value = DoubleType.DOUBLE.getDouble(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class RealJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private RealJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                float value = Float.intBitsToFloat((int)RealType.REAL.getLong(block, position));
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class LongJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final Type type;

        public LongJsonGeneratorWriter(Type type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = this.type.getLong(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class BooleanJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private BooleanJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                boolean value = BooleanType.BOOLEAN.getBoolean(block, position);
                jsonGenerator.writeBoolean(value);
            }
        }
    }

    private static class UnknownJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private UnknownJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position, SqlFunctionProperties properties) throws IOException {
            jsonGenerator.writeNull();
        }
    }

    public static interface JsonGeneratorWriter {
        public void writeJsonValue(JsonGenerator var1, Block var2, int var3, SqlFunctionProperties var4) throws IOException;

        public static JsonGeneratorWriter createJsonGeneratorWriter(Type type) {
            TypeSignature signature = type.getTypeSignature();
            String baseType = signature.getBase();
            if (signature.isLongEnum()) {
                return new LongJsonGeneratorWriter(type);
            }
            if (signature.isVarcharEnum()) {
                return new VarcharJsonGeneratorWriter(type);
            }
            switch (baseType) {
                case "unknown": {
                    return new UnknownJsonGeneratorWriter();
                }
                case "boolean": {
                    return new BooleanJsonGeneratorWriter();
                }
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    return new LongJsonGeneratorWriter(type);
                }
                case "real": {
                    return new RealJsonGeneratorWriter();
                }
                case "double": {
                    return new DoubleJsonGeneratorWriter();
                }
                case "decimal": {
                    if (Decimals.isShortDecimal((Type)type)) {
                        return new ShortDecimalJsonGeneratorWriter((DecimalType)type);
                    }
                    return new LongDeicmalJsonGeneratorWriter((DecimalType)type);
                }
                case "varchar": {
                    return new VarcharJsonGeneratorWriter(type);
                }
                case "json": {
                    return new JsonJsonGeneratorWriter();
                }
                case "timestamp": {
                    return new TimestampJsonGeneratorWriter();
                }
                case "date": {
                    return new DateGeneratorWriter();
                }
                case "array": {
                    ArrayType arrayType = (ArrayType)type;
                    return new ArrayJsonGeneratorWriter(arrayType, JsonGeneratorWriter.createJsonGeneratorWriter(arrayType.getElementType()));
                }
                case "map": {
                    MapType mapType = (MapType)type;
                    return new MapJsonGeneratorWriter(mapType, ObjectKeyProvider.createObjectKeyProvider(mapType.getKeyType()), JsonGeneratorWriter.createJsonGeneratorWriter(mapType.getValueType()));
                }
                case "row": {
                    List fieldTypes = type.getTypeParameters();
                    ArrayList<JsonGeneratorWriter> fieldWriters = new ArrayList<JsonGeneratorWriter>(fieldTypes.size());
                    for (int i = 0; i < fieldTypes.size(); ++i) {
                        fieldWriters.add(JsonGeneratorWriter.createJsonGeneratorWriter((Type)fieldTypes.get(i)));
                    }
                    return new RowJsonGeneratorWriter((RowType)type, fieldWriters);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }

    public static interface ObjectKeyProvider {
        public String getObjectKey(Block var1, int var2);

        public static ObjectKeyProvider createObjectKeyProvider(Type type) {
            TypeSignature signature = type.getTypeSignature();
            String baseType = signature.getBase();
            if (signature.isLongEnum()) {
                return (block, position) -> String.valueOf(type.getLong(block, position));
            }
            if (signature.isVarcharEnum()) {
                return (block, position) -> type.getSlice(block, position).toStringUtf8();
            }
            switch (baseType) {
                case "unknown": {
                    return (block, position) -> null;
                }
                case "boolean": {
                    return (block, position) -> type.getBoolean(block, position) ? "true" : "false";
                }
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    return (block, position) -> String.valueOf(type.getLong(block, position));
                }
                case "real": {
                    return (block, position) -> String.valueOf(Float.intBitsToFloat((int)type.getLong(block, position)));
                }
                case "double": {
                    return (block, position) -> String.valueOf(type.getDouble(block, position));
                }
                case "decimal": {
                    DecimalType decimalType = (DecimalType)type;
                    if (Decimals.isShortDecimal((Type)decimalType)) {
                        return (block, position) -> Decimals.toString((long)decimalType.getLong(block, position), (int)decimalType.getScale());
                    }
                    return (block, position) -> Decimals.toString((BigInteger)Decimals.decodeUnscaledValue((Slice)type.getSlice(block, position)), (int)decimalType.getScale());
                }
                case "varchar": {
                    return (block, position) -> type.getSlice(block, position).toStringUtf8();
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }
}

