/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.common.type.RowType;
import java.util.List;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegacyRowFieldOrdinalAccessUtil {
    private static final Pattern ORDINAL_ROW_FIELD_NAME = Pattern.compile("(?i)field([0-9]+)");

    private LegacyRowFieldOrdinalAccessUtil() {
    }

    public static OptionalInt parseAnonymousRowFieldOrdinalAccess(String fieldName, List<RowType.Field> rowFields) {
        int rowIndex;
        Matcher matcher = ORDINAL_ROW_FIELD_NAME.matcher(fieldName);
        if (!matcher.matches()) {
            return OptionalInt.empty();
        }
        try {
            rowIndex = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
        if (rowIndex >= rowFields.size()) {
            return OptionalInt.empty();
        }
        if (rowFields.get(rowIndex).getName().isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(rowIndex);
    }
}

