/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.version;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class EmbedVersion {
    private final MethodHandle runnableConstructor;

    @Inject
    public EmbedVersion(ServerConfig serverConfig) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(EmbedVersion.baseClassName(serverConfig)), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Runnable.class)});
        FieldDefinition field = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "runnable", Runnable.class);
        Parameter parameter = Parameter.arg((String)"runnable", (ParameterizedType)ParameterizedType.type(Runnable.class));
        MethodDefinition constructor = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{parameter});
        constructor.getBody().comment("super(runnable);").append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructor.getThis()).append((BytecodeNode)parameter).putField(field).ret();
        MethodDefinition run = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "run", ParameterizedType.type(Void.TYPE), new Parameter[0]);
        run.getBody().comment("runnable.run();").append((BytecodeNode)run.getThis()).getField(field).invokeInterface(Runnable.class, "run", Void.TYPE, new Class[0]).ret();
        Class<Runnable> generatedClass = CompilerUtils.defineClass(classDefinition, Runnable.class, (Map<Long, MethodHandle>)ImmutableMap.of(), this.getClass().getClassLoader());
        this.runnableConstructor = Reflection.constructorMethodHandle(generatedClass, Runnable.class);
    }

    private static String baseClassName(ServerConfig serverConfig) {
        String configuredVersion;
        String builtInVersion = new ServerConfig().getPrestoVersion();
        String version = configuredVersion = serverConfig.getPrestoVersion();
        if (!Objects.equals(builtInVersion, configuredVersion)) {
            version = String.format("%s__%s", builtInVersion, configuredVersion);
        }
        return String.format("Presto_%s___", version);
    }

    public Runnable embedVersion(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable is null");
        try {
            return this.runnableConstructor.invoke(runnable);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }
}

