/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.io.Resources;
import io.airlift.tpch.Distribution;
import io.airlift.tpch.DistributionLoader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Supplier;

public class Distributions {
    private static final Supplier<Distributions> DEFAULT_DISTRIBUTIONS = Suppliers.memoize(Distributions::loadDefaults);
    private final Distribution grammars;
    private final Distribution nounPhrase;
    private final Distribution verbPhrase;
    private final Distribution prepositions;
    private final Distribution nouns;
    private final Distribution verbs;
    private final Distribution articles;
    private final Distribution adjectives;
    private final Distribution adverbs;
    private final Distribution auxiliaries;
    private final Distribution terminators;
    private final Distribution orderPriorities;
    private final Distribution shipInstructions;
    private final Distribution shipModes;
    private final Distribution returnFlags;
    private final Distribution partContainers;
    private final Distribution partColors;
    private final Distribution partTypes;
    private final Distribution marketSegments;
    private final Distribution nations;
    private final Distribution regions;

    private static Distributions loadDefaults() {
        try {
            URL resource = Resources.getResource(Distribution.class, (String)"dists.dss");
            Preconditions.checkState((resource != null ? 1 : 0) != 0, (Object)"Distribution file 'dists.dss' not found");
            return new Distributions(DistributionLoader.loadDistribution(Resources.asCharSource((URL)resource, (Charset)StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Distributions getDefaultDistributions() {
        return DEFAULT_DISTRIBUTIONS.get();
    }

    public Distributions(Map<String, Distribution> distributions) {
        this.grammars = Distributions.getDistribution(distributions, "grammar");
        this.nounPhrase = Distributions.getDistribution(distributions, "np");
        this.verbPhrase = Distributions.getDistribution(distributions, "vp");
        this.prepositions = Distributions.getDistribution(distributions, "prepositions");
        this.nouns = Distributions.getDistribution(distributions, "nouns");
        this.verbs = Distributions.getDistribution(distributions, "verbs");
        this.articles = Distributions.getDistribution(distributions, "articles");
        this.adjectives = Distributions.getDistribution(distributions, "adjectives");
        this.adverbs = Distributions.getDistribution(distributions, "adverbs");
        this.auxiliaries = Distributions.getDistribution(distributions, "auxillaries");
        this.terminators = Distributions.getDistribution(distributions, "terminators");
        this.orderPriorities = Distributions.getDistribution(distributions, "o_oprio");
        this.shipInstructions = Distributions.getDistribution(distributions, "instruct");
        this.shipModes = Distributions.getDistribution(distributions, "smode");
        this.returnFlags = Distributions.getDistribution(distributions, "rflag");
        this.partContainers = Distributions.getDistribution(distributions, "p_cntr");
        this.partColors = Distributions.getDistribution(distributions, "colors");
        this.partTypes = Distributions.getDistribution(distributions, "p_types");
        this.marketSegments = Distributions.getDistribution(distributions, "msegmnt");
        this.nations = Distributions.getDistribution(distributions, "nations");
        this.regions = Distributions.getDistribution(distributions, "regions");
    }

    public Distribution getAdjectives() {
        return this.adjectives;
    }

    public Distribution getAdverbs() {
        return this.adverbs;
    }

    public Distribution getArticles() {
        return this.articles;
    }

    public Distribution getAuxiliaries() {
        return this.auxiliaries;
    }

    public Distribution getGrammars() {
        return this.grammars;
    }

    public Distribution getMarketSegments() {
        return this.marketSegments;
    }

    public Distribution getNations() {
        return this.nations;
    }

    public Distribution getNounPhrase() {
        return this.nounPhrase;
    }

    public Distribution getNouns() {
        return this.nouns;
    }

    public Distribution getOrderPriorities() {
        return this.orderPriorities;
    }

    public Distribution getPartColors() {
        return this.partColors;
    }

    public Distribution getPartContainers() {
        return this.partContainers;
    }

    public Distribution getPartTypes() {
        return this.partTypes;
    }

    public Distribution getPrepositions() {
        return this.prepositions;
    }

    public Distribution getRegions() {
        return this.regions;
    }

    public Distribution getReturnFlags() {
        return this.returnFlags;
    }

    public Distribution getShipInstructions() {
        return this.shipInstructions;
    }

    public Distribution getShipModes() {
        return this.shipModes;
    }

    public Distribution getTerminators() {
        return this.terminators;
    }

    public Distribution getVerbPhrase() {
        return this.verbPhrase;
    }

    public Distribution getVerbs() {
        return this.verbs;
    }

    private static Distribution getDistribution(Map<String, Distribution> distributions, String name) {
        Distribution distribution = distributions.get(name);
        Preconditions.checkArgument((distribution != null ? 1 : 0) != 0, (Object)"Distribution %s does not exist");
        return distribution;
    }
}

