/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.Order;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchColumnTypes;

public enum OrderColumn implements TpchColumn<Order>
{
    ORDER_KEY("o_orderkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Order order) {
            return order.getOrderKey();
        }
    }
    ,
    CUSTOMER_KEY("o_custkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Order order) {
            return order.getCustomerKey();
        }
    }
    ,
    ORDER_STATUS("o_orderstatus", TpchColumnTypes.varchar(1L)){

        @Override
        public String getString(Order order) {
            return String.valueOf(order.getOrderStatus());
        }
    }
    ,
    TOTAL_PRICE("o_totalprice", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(Order order) {
            return order.getTotalPrice();
        }

        @Override
        public long getIdentifier(Order order) {
            return order.getTotalPriceInCents();
        }
    }
    ,
    ORDER_DATE("o_orderdate", TpchColumnTypes.DATE){

        @Override
        public String getString(Order order) {
            return GenerateUtils.formatDate(this.getDate(order));
        }

        @Override
        public int getDate(Order order) {
            return order.getOrderDate();
        }
    }
    ,
    ORDER_PRIORITY("o_orderpriority", TpchColumnTypes.varchar(15L)){

        @Override
        public String getString(Order order) {
            return order.getOrderPriority();
        }
    }
    ,
    CLERK("o_clerk", TpchColumnTypes.varchar(15L)){

        @Override
        public String getString(Order order) {
            return order.getClerk();
        }
    }
    ,
    SHIP_PRIORITY("o_shippriority", TpchColumnTypes.INTEGER){

        @Override
        public int getInteger(Order order) {
            return order.getShipPriority();
        }
    }
    ,
    COMMENT("o_comment", TpchColumnTypes.varchar(79L)){

        @Override
        public String getString(Order order) {
            return order.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private OrderColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(Order entity) {
        throw new UnsupportedOperationException();
    }
}

