/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.tpch.Customer;
import io.airlift.tpch.CustomerColumn;
import io.airlift.tpch.CustomerGenerator;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemColumn;
import io.airlift.tpch.LineItemGenerator;
import io.airlift.tpch.Nation;
import io.airlift.tpch.NationColumn;
import io.airlift.tpch.NationGenerator;
import io.airlift.tpch.Order;
import io.airlift.tpch.OrderColumn;
import io.airlift.tpch.OrderGenerator;
import io.airlift.tpch.Part;
import io.airlift.tpch.PartColumn;
import io.airlift.tpch.PartGenerator;
import io.airlift.tpch.PartSupplier;
import io.airlift.tpch.PartSupplierColumn;
import io.airlift.tpch.PartSupplierGenerator;
import io.airlift.tpch.Region;
import io.airlift.tpch.RegionColumn;
import io.airlift.tpch.RegionGenerator;
import io.airlift.tpch.Supplier;
import io.airlift.tpch.SupplierColumn;
import io.airlift.tpch.SupplierGenerator;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchEntity;
import java.util.List;
import java.util.Map;

public abstract class TpchTable<E extends TpchEntity> {
    public static final TpchTable<Customer> CUSTOMER = new TpchTable<Customer>("customer", (TpchColumn[])CustomerColumn.values()){

        @Override
        public Iterable<Customer> createGenerator(double scaleFactor, int part, int partCount) {
            return new CustomerGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Order> ORDERS = new TpchTable<Order>("orders", (TpchColumn[])OrderColumn.values()){

        @Override
        public Iterable<Order> createGenerator(double scaleFactor, int part, int partCount) {
            return new OrderGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<LineItem> LINE_ITEM = new TpchTable<LineItem>("lineitem", (TpchColumn[])LineItemColumn.values()){

        @Override
        public Iterable<LineItem> createGenerator(double scaleFactor, int part, int partCount) {
            return new LineItemGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Part> PART = new TpchTable<Part>("part", (TpchColumn[])PartColumn.values()){

        @Override
        public Iterable<Part> createGenerator(double scaleFactor, int part, int partCount) {
            return new PartGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<PartSupplier> PART_SUPPLIER = new TpchTable<PartSupplier>("partsupp", (TpchColumn[])PartSupplierColumn.values()){

        @Override
        public Iterable<PartSupplier> createGenerator(double scaleFactor, int part, int partCount) {
            return new PartSupplierGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Supplier> SUPPLIER = new TpchTable<Supplier>("supplier", (TpchColumn[])SupplierColumn.values()){

        @Override
        public Iterable<Supplier> createGenerator(double scaleFactor, int part, int partCount) {
            return new SupplierGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Nation> NATION = new TpchTable<Nation>("nation", (TpchColumn[])NationColumn.values()){

        @Override
        public Iterable<Nation> createGenerator(double scaleFactor, int part, int partCount) {
            if (part != 1) {
                return ImmutableList.of();
            }
            return new NationGenerator();
        }
    };
    public static final TpchTable<Region> REGION = new TpchTable<Region>("region", (TpchColumn[])RegionColumn.values()){

        @Override
        public Iterable<Region> createGenerator(double scaleFactor, int part, int partCount) {
            if (part != 1) {
                return ImmutableList.of();
            }
            return new RegionGenerator();
        }
    };
    private static final List<TpchTable<?>> TABLES = ImmutableList.of(CUSTOMER, ORDERS, LINE_ITEM, PART, PART_SUPPLIER, SUPPLIER, NATION, REGION);
    private static final Map<String, TpchTable<?>> TABLES_BY_NAME = Maps.uniqueIndex(TABLES, TpchTable::getTableName);
    private final String tableName;
    private final List<TpchColumn<E>> columns;
    private final Map<String, TpchColumn<E>> columnsByName;

    public static List<TpchTable<?>> getTables() {
        return TABLES;
    }

    public static TpchTable<?> getTable(String tableName) {
        TpchTable<?> table = TABLES_BY_NAME.get(tableName);
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (String)"Table %s not found", (Object)tableName);
        return table;
    }

    private TpchTable(String tableName, TpchColumn<E>[] columns) {
        this.tableName = tableName;
        this.columns = ImmutableList.copyOf((Object[])columns);
        this.columnsByName = new ImmutableMap.Builder().putAll((Map)Maps.uniqueIndex(this.columns, TpchColumn::getColumnName)).putAll((Map)Maps.uniqueIndex(this.columns, TpchColumn::getSimplifiedColumnName)).build();
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<TpchColumn<E>> getColumns() {
        return this.columns;
    }

    public TpchColumn<E> getColumn(String columnName) {
        TpchColumn<E> column = this.columnsByName.get(columnName);
        Preconditions.checkArgument((column != null ? 1 : 0) != 0, (String)"Table %s does not have a column %s", (Object)this.tableName, (Object)columnName);
        return column;
    }

    public abstract Iterable<E> createGenerator(double var1, int var3, int var4);
}

