/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.EventClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class MultiEventClient
implements EventClient {
    private final Set<EventClient> clients;

    public MultiEventClient(EventClient ... clients) {
        this((Set<EventClient>)ImmutableSet.copyOf((Object[])clients));
    }

    @Inject
    public MultiEventClient(Set<EventClient> clients) {
        this.clients = clients;
    }

    @Override
    @SafeVarargs
    public final <T> ListenableFuture<Void> post(T ... event) throws IllegalArgumentException {
        return this.post((Iterable<T>)ImmutableList.copyOf((Object[])event));
    }

    @Override
    public <T> ListenableFuture<Void> post(Iterable<T> events) throws IllegalArgumentException {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (EventClient client : this.clients) {
            futures.add(client.post(events));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)futures.build()), x -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public <T> ListenableFuture<Void> post(EventClient.EventGenerator<T> eventGenerator) throws IllegalArgumentException {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (EventClient client : this.clients) {
            futures.add(client.post(eventGenerator));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)futures.build()), x -> null, (Executor)MoreExecutors.directExecutor());
    }
}

