/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.XmlMethodSelector;

public class ClassMethodMap {
    private Map<Object, List<ITestNGMethod>> m_classMap = Maps.newHashMap();
    private Map<ITestClass, Set<Object>> m_beforeClassMethods = Maps.newHashMap();
    private Map<ITestClass, Set<Object>> m_afterClassMethods = Maps.newHashMap();

    public ClassMethodMap(List<ITestNGMethod> list, XmlMethodSelector xmlMethodSelector) {
        for (ITestNGMethod iTestNGMethod : list) {
            if (xmlMethodSelector != null && !xmlMethodSelector.includeMethod(null, iTestNGMethod, true)) continue;
            Object object = iTestNGMethod.getInstance();
            List<ITestNGMethod> list2 = this.m_classMap.get(object);
            if (list2 == null) {
                list2 = Lists.newArrayList();
                this.m_classMap.put(object, list2);
            }
            list2.add(iTestNGMethod);
        }
    }

    public synchronized boolean removeAndCheckIfLast(ITestNGMethod iTestNGMethod, Object object) {
        List<ITestNGMethod> list = this.m_classMap.get(object);
        if (list != null) {
            list.remove(iTestNGMethod);
            for (ITestNGMethod iTestNGMethod2 : list) {
                if (!iTestNGMethod2.getEnabled() || !iTestNGMethod2.getTestClass().equals(iTestNGMethod.getTestClass())) continue;
                return false;
            }
            return true;
        }
        throw new AssertionError((Object)"l should not be null");
    }

    private Class<?> getMethodClass(ITestNGMethod iTestNGMethod) {
        return iTestNGMethod.getTestClass().getRealClass();
    }

    public Map<ITestClass, Set<Object>> getInvokedBeforeClassMethods() {
        return this.m_beforeClassMethods;
    }

    public Map<ITestClass, Set<Object>> getInvokedAfterClassMethods() {
        return this.m_afterClassMethods;
    }

    public void clear() {
        for (Set<Object> set : this.m_beforeClassMethods.values()) {
            set.clear();
            set = null;
        }
        for (Set<Object> set : this.m_afterClassMethods.values()) {
            set.clear();
            set = null;
        }
        this.m_beforeClassMethods.clear();
        this.m_afterClassMethods.clear();
    }
}

