/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IAttributes;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Attributes;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class SuiteRunner
implements ISuite,
Serializable,
IInvokedMethodListener {
    private static final long serialVersionUID = 5284208932089503131L;
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> m_suiteResults = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private transient List<TestRunner> m_testRunners = Lists.newArrayList();
    private transient Map<Class<? extends ISuiteListener>, ISuiteListener> m_listeners = Maps.newHashMap();
    private transient TestListenerAdapter m_textReporter = new TestListenerAdapter();
    private String m_outputDir;
    private XmlSuite m_suite;
    private Injector m_parentInjector;
    private transient List<ITestListener> m_testListeners = Lists.newArrayList();
    private final transient Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newHashMap();
    private transient ITestRunnerFactory m_tmpRunnerFactory;
    private transient ITestRunnerFactory m_runnerFactory;
    private transient boolean m_useDefaultListeners = true;
    private String m_host;
    private transient IConfiguration m_configuration;
    private transient ITestObjectFactory m_objectFactory;
    private transient Boolean m_skipFailedInvocationCounts = Boolean.FALSE;
    private transient List<IMethodInterceptor> m_methodInterceptors;
    private Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> m_invokedMethodListeners;
    private List<IInvokedMethod> m_invokedMethods = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestNGMethod> m_allTestMethods = Lists.newArrayList();
    private List<IReporter> m_reporters = Lists.newArrayList();
    private SuiteRunState m_suiteState = new SuiteRunState();
    private IAttributes m_attributes = new Attributes();

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string) {
        this(iConfiguration, xmlSuite, string, null);
    }

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory) {
        this(iConfiguration, xmlSuite, string, iTestRunnerFactory, false);
    }

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl) {
        this(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, (List<IMethodInterceptor>)new ArrayList<IMethodInterceptor>(), (List<IInvokedMethodListener>)null, (List<ITestListener>)null, (List<IClassListener>)null);
    }

    @Deprecated
    protected SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> list, List<IInvokedMethodListener> list2, List<ITestListener> list3, List<IClassListener> list4) {
        this.init(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, list, list2, list3, list4);
    }

    protected SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> list, Collection<IInvokedMethodListener> collection, Collection<ITestListener> collection2, Collection<IClassListener> collection3) {
        this.init(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, list, collection, collection2, collection3);
    }

    private void init(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> arrayList, Collection<IInvokedMethodListener> collection, Collection<ITestListener> collection2, Collection<IClassListener> collection3) {
        this.m_configuration = iConfiguration;
        this.m_suite = xmlSuite;
        this.m_useDefaultListeners = bl;
        this.m_tmpRunnerFactory = iTestRunnerFactory;
        this.m_methodInterceptors = arrayList != null ? arrayList : new ArrayList();
        this.setOutputDir(string);
        this.m_objectFactory = this.m_configuration.getObjectFactory();
        if (this.m_objectFactory == null) {
            this.m_objectFactory = xmlSuite.getObjectFactory();
        }
        this.m_invokedMethodListeners = Maps.newHashMap();
        if (collection != null) {
            for (IInvokedMethodListener object2 : collection) {
                this.m_invokedMethodListeners.put(object2.getClass(), object2);
            }
        }
        this.m_invokedMethodListeners.put(this.getClass(), this);
        this.m_skipFailedInvocationCounts = xmlSuite.skipFailedInvocationCounts();
        if (null != collection2) {
            this.m_testListeners.addAll(collection2);
        }
        if (null != collection3) {
            for (IClassListener iClassListener : collection3) {
                this.m_classListeners.put(iClassListener.getClass(), iClassListener);
            }
        }
        this.m_runnerFactory = this.buildRunnerFactory();
        List<XmlTest> list = this.m_suite.getTests();
        Collections.sort(list, new Comparator<XmlTest>(){

            @Override
            public int compare(XmlTest xmlTest, XmlTest xmlTest2) {
                return xmlTest.getIndex() - xmlTest2.getIndex();
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XmlTest xmlTest = (XmlTest)iterator.next();
            TestRunner testRunner = this.m_runnerFactory.newTestRunner(this, xmlTest, this.m_invokedMethodListeners.values(), Lists.newArrayList(this.m_classListeners.values()));
            for (IMethodInterceptor iMethodInterceptor : this.m_methodInterceptors) {
                testRunner.addMethodInterceptor(iMethodInterceptor);
            }
            testRunner.addListener(this.m_textReporter);
            this.m_testRunners.add(testRunner);
            this.m_allTestMethods.addAll(Arrays.asList(testRunner.getAllTestMethods()));
        }
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.m_suite;
    }

    @Override
    public String getName() {
        return this.m_suite.getName();
    }

    public void setObjectFactory(ITestObjectFactory iTestObjectFactory) {
        this.m_objectFactory = iTestObjectFactory;
    }

    public void setReportResults(boolean bl) {
        this.m_useDefaultListeners = bl;
    }

    private void invokeListeners(boolean bl) {
        for (ISuiteListener iSuiteListener : this.m_listeners.values()) {
            if (bl) {
                iSuiteListener.onStart(this);
                continue;
            }
            iSuiteListener.onFinish(this);
        }
    }

    private void setOutputDir(String string) {
        if (Utils.isStringBlank(string) && this.m_useDefaultListeners) {
            string = DEFAULT_OUTPUT_DIR;
        }
        this.m_outputDir = null != string ? new File(string).getAbsolutePath() : null;
    }

    private ITestRunnerFactory buildRunnerFactory() {
        ITestRunnerFactory iTestRunnerFactory = null;
        iTestRunnerFactory = null == this.m_tmpRunnerFactory ? new DefaultTestRunnerFactory(this.m_configuration, this.m_testListeners.toArray(new ITestListener[this.m_testListeners.size()]), this.m_useDefaultListeners, this.m_skipFailedInvocationCounts) : new ProxyTestRunnerFactory(this.m_testListeners.toArray(new ITestListener[this.m_testListeners.size()]), this.m_tmpRunnerFactory);
        return iTestRunnerFactory;
    }

    @Override
    public String getParallel() {
        return this.m_suite.getParallel().toString();
    }

    @Override
    public String getParentModule() {
        return this.m_suite.getParentModule();
    }

    @Override
    public String getGuiceStage() {
        return this.m_suite.getGuiceStage();
    }

    @Override
    public Injector getParentInjector() {
        return this.m_parentInjector;
    }

    @Override
    public void setParentInjector(Injector injector) {
        this.m_parentInjector = injector;
    }

    @Override
    public void run() {
        this.invokeListeners(true);
        try {
            this.privateRun();
        }
        finally {
            this.invokeListeners(false);
        }
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> linkedHashMap = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> linkedHashMap2 = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker iInvoker = null;
        for (TestRunner testRunner : this.m_testRunners) {
            iInvoker = testRunner.getInvoker();
            for (ITestNGMethod iTestNGMethod : testRunner.getBeforeSuiteMethods()) {
                linkedHashMap.put(iTestNGMethod.getConstructorOrMethod().getMethod(), iTestNGMethod);
            }
            for (ITestNGMethod iTestNGMethod : testRunner.getAfterSuiteMethods()) {
                linkedHashMap2.put(iTestNGMethod.getConstructorOrMethod().getMethod(), iTestNGMethod);
            }
        }
        if (iInvoker != null) {
            if (linkedHashMap.values().size() > 0) {
                iInvoker.invokeConfigurations(null, linkedHashMap.values().toArray(new ITestNGMethod[linkedHashMap.size()]), this.m_suite, this.m_suite.getParameters(), null, null);
            }
            Utils.log("SuiteRunner", 3, "Created " + this.m_testRunners.size() + " TestRunners");
            boolean bl = XmlSuite.ParallelMode.TESTS.equals((Object)this.m_suite.getParallel());
            if (!bl) {
                this.runSequentially();
            } else {
                this.runInParallelTestMode();
            }
            if (linkedHashMap2.values().size() > 0) {
                iInvoker.invokeConfigurations(null, linkedHashMap2.values().toArray(new ITestNGMethod[linkedHashMap2.size()]), this.m_suite, this.m_suite.getAllParameters(), null, null);
            }
        }
    }

    private void addReporter(IReporter iReporter) {
        this.m_reporters.add(iReporter);
    }

    void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.m_configuration.addConfigurationListener(iConfigurationListener);
    }

    public List<IReporter> getReporters() {
        return this.m_reporters;
    }

    private void runSequentially() {
        for (TestRunner testRunner : this.m_testRunners) {
            this.runTest(testRunner);
        }
    }

    private void runTest(TestRunner testRunner) {
        testRunner.run();
        SuiteResult suiteResult = new SuiteResult(this.m_suite, testRunner);
        this.m_suiteResults.put(testRunner.getName(), suiteResult);
    }

    private void runInParallelTestMode() {
        List list = Lists.newArrayList(this.m_testRunners.size());
        for (TestRunner testRunner : this.m_testRunners) {
            list.add(new SuiteWorker(testRunner));
        }
        ThreadUtil.execute(list, this.m_suite.getThreadCount(), this.m_suite.getTimeOut(Integer.MAX_VALUE), false);
    }

    protected void addListener(ISuiteListener iSuiteListener) {
        if (!this.m_listeners.containsKey(iSuiteListener.getClass())) {
            this.m_listeners.put(iSuiteListener.getClass(), iSuiteListener);
        }
    }

    @Override
    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener instanceof IInvokedMethodListener) {
            iTestNGListener2 = (IInvokedMethodListener)iTestNGListener;
            this.m_invokedMethodListeners.put(iTestNGListener2.getClass(), (IInvokedMethodListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof ISuiteListener) {
            this.addListener((ISuiteListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IReporter) {
            this.addReporter((IReporter)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IClassListener && !this.m_classListeners.containsKey((iTestNGListener2 = (IClassListener)iTestNGListener).getClass())) {
            this.m_classListeners.put(iTestNGListener2.getClass(), (IClassListener)iTestNGListener2);
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.m_suiteResults;
    }

    @Override
    public String getParameter(String string) {
        return this.m_suite.getParameter(string);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        Map<String, Collection<ITestNGMethod>> map = Maps.newHashMap();
        for (TestRunner testRunner : this.m_testRunners) {
            ITestNGMethod[] iTestNGMethodArray;
            for (ITestNGMethod iTestNGMethod : iTestNGMethodArray = testRunner.getAllTestMethods()) {
                String[] stringArray;
                for (String string : stringArray = iTestNGMethod.getGroups()) {
                    Collection<ITestNGMethod> collection = map.get(string);
                    if (null == collection) {
                        collection = Lists.newArrayList();
                        map.put(string, collection);
                    }
                    collection.add(iTestNGMethod);
                }
            }
        }
        return map;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        return this.getIncludedOrExcludedMethods(true);
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean bl) {
        List<ITestNGMethod> list = Lists.newArrayList();
        for (TestRunner testRunner : this.m_testRunners) {
            Collection<ITestNGMethod> collection = bl ? testRunner.getInvokedMethods() : testRunner.getExcludedMethods();
            for (ITestNGMethod iTestNGMethod : collection) {
                list.add(iTestNGMethod);
            }
        }
        return list;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.m_objectFactory instanceof IObjectFactory ? (IObjectFactory)this.m_objectFactory : null;
    }

    @Override
    public IObjectFactory2 getObjectFactory2() {
        return this.m_objectFactory instanceof IObjectFactory2 ? (IObjectFactory2)this.m_objectFactory : null;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.m_configuration.getAnnotationFinder();
    }

    public static void ppp(String string) {
        System.out.println("[SuiteRunner] " + string);
    }

    public void setHost(String string) {
        this.m_host = string;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.m_suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean bl) {
        if (bl != null) {
            this.m_skipFailedInvocationCounts = bl;
        }
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.m_attributes.removeAttribute(string);
    }

    @Override
    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
    }

    @Override
    public void beforeInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (iInvokedMethod == null) {
            throw new NullPointerException("Method should not be null");
        }
        this.m_invokedMethods.add(iInvokedMethod);
    }

    @Override
    public List<IInvokedMethod> getAllInvokedMethods() {
        return this.m_invokedMethods;
    }

    @Override
    public List<ITestNGMethod> getAllMethods() {
        return this.m_allTestMethods;
    }

    private static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private ITestRunnerFactory m_target;

        public ProxyTestRunnerFactory(ITestListener[] iTestListenerArray, ITestRunnerFactory iTestRunnerFactory) {
            this.m_failureGenerators = iTestListenerArray;
            this.m_target = iTestRunnerFactory;
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
            TestRunner testRunner = this.m_target.newTestRunner(iSuite, xmlTest, collection, list);
            testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener iTestListener : this.m_failureGenerators) {
                testRunner.addListener(iTestListener);
            }
            return testRunner;
        }
    }

    private static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private boolean m_useDefaultListeners;
        private boolean m_skipFailedInvocationCounts;
        private IConfiguration m_configuration;

        public DefaultTestRunnerFactory(IConfiguration iConfiguration, ITestListener[] iTestListenerArray, boolean bl, boolean bl2) {
            this.m_configuration = iConfiguration;
            this.m_failureGenerators = iTestListenerArray;
            this.m_useDefaultListeners = bl;
            this.m_skipFailedInvocationCounts = bl2;
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
            boolean bl = this.m_skipFailedInvocationCounts;
            if (!bl) {
                bl = xmlTest.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(this.m_configuration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
            if (this.m_useDefaultListeners) {
                testRunner.addListener(new TestHTMLReporter());
                testRunner.addListener(new JUnitXMLReporter());
                testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener iTestListener : this.m_failureGenerators) {
                testRunner.addTestListener(iTestListener);
            }
            for (IConfigurationListener iConfigurationListener : this.m_configuration.getConfigurationListeners()) {
                testRunner.addConfigurationListener(iConfigurationListener);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner m_testRunner;

        public SuiteWorker(TestRunner testRunner) {
            this.m_testRunner = testRunner;
        }

        @Override
        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.m_testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.m_testRunner);
        }
    }
}

