/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.testng.IConfigurable;
import org.testng.IConfigureCallBack;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.ArrayIterator;
import org.testng.internal.collections.OneToTwoDimArrayIterator;
import org.testng.internal.collections.OneToTwoDimIterator;
import org.testng.internal.collections.Pair;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IFutureResult;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadTimeoutException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlSuite;

public class MethodInvocationHelper {
    protected static Object invokeMethodNoCheckedException(Method method, Object object, List<Object> list) {
        try {
            return MethodInvocationHelper.invokeMethod(method, object, list);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException.getCause());
        }
    }

    protected static Object invokeMethod(Method method, Object object, List<Object> list) throws InvocationTargetException, IllegalAccessException {
        return MethodInvocationHelper.invokeMethod(method, object, list.toArray(new Object[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object invokeMethod(Method method, Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        block11: {
            boolean bl;
            Utils.checkInstanceOrStatic(object, method);
            if (!(object != null && method.getDeclaringClass().isAssignableFrom(object.getClass()) || (bl = Modifier.isStatic(method.getModifiers())))) {
                Class<?> clazz;
                try {
                    method = clazz.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (Exception exception) {
                    boolean bl2 = false;
                    for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        try {
                            method = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                            bl2 = true;
                            break;
                        }
                        catch (Exception exception2) {
                            continue;
                        }
                    }
                    if (bl2) break block11;
                    if (method.getDeclaringClass().getName().equals(object.getClass().getName())) {
                        throw new RuntimeException("Can't invoke method " + method + ", probably due to classloader mismatch");
                    }
                    throw new RuntimeException("Can't invoke method " + method + " on this instance of " + object.getClass() + " due to class mismatch");
                }
            }
        }
        Method method2 = method;
        synchronized (method2) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        return method.invoke(object, objectArray);
    }

    protected static Iterator<Object[]> invokeDataProvider(Object object, Method method, ITestNGMethod iTestNGMethod, ITestContext iTestContext, Object object2, IAnnotationFinder iAnnotationFinder) {
        List<Object> list = MethodInvocationHelper.getParameters(method, iTestNGMethod, iTestContext, object2, iAnnotationFinder);
        Object object3 = MethodInvocationHelper.invokeMethodNoCheckedException(method, object, list);
        if (object3 instanceof Object[][]) {
            return new ArrayIterator((Object[][])object3);
        }
        if (object3 instanceof Object[]) {
            return new OneToTwoDimArrayIterator((Object[])object3);
        }
        if (object3 instanceof Iterator) {
            Type type = method.getGenericReturnType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
                if (clazz.isArray()) {
                    return (Iterator)object3;
                }
                return new OneToTwoDimIterator((Iterator)object3);
            }
            return (Iterator)object3;
        }
        throw new TestNGException("Data Provider " + method + " must return either Object[][] or Iterator<Object>[], not " + method.getReturnType());
    }

    /*
     * WARNING - void declaration
     */
    private static List<Object> getParameters(Method method, ITestNGMethod iTestNGMethod, ITestContext iTestContext, Object object, IAnnotationFinder iAnnotationFinder) {
        void pair;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
        int n = 0;
        Object stringBuilder = method.getParameterTypes();
        int n2 = ((Class<?>[])stringBuilder).length;
        boolean bl = false;
        while (pair < n2) {
            Class<?> clazz = stringBuilder[pair];
            if (clazz.equals(Method.class)) {
                arrayList.add(constructorOrMethod.getMethod());
            } else if (clazz.equals(Constructor.class)) {
                arrayList.add(constructorOrMethod.getConstructor());
            } else if (clazz.equals(ConstructorOrMethod.class)) {
                arrayList.add(constructorOrMethod);
            } else if (clazz.equals(ITestNGMethod.class)) {
                arrayList.add(iTestNGMethod);
            } else if (clazz.equals(ITestContext.class)) {
                arrayList.add(iTestContext);
            } else {
                boolean bl2 = iAnnotationFinder.hasTestInstance(method, n);
                if (bl2) {
                    arrayList.add(object);
                } else {
                    arrayList2.add(new Pair(n, clazz));
                }
            }
            ++n;
            ++pair;
        }
        if (!arrayList2.isEmpty()) {
            stringBuilder = new StringBuilder();
            ((StringBuilder)stringBuilder).append("Some DataProvider ").append(method).append(" parameters unresolved: ");
            for (Pair pair2 : arrayList2) {
                ((StringBuilder)stringBuilder).append(" at ").append(pair2.first()).append(" type ").append(pair2.second()).append("\n");
            }
            throw new TestNGException(((StringBuilder)stringBuilder).toString());
        }
        return arrayList;
    }

    protected static void invokeHookable(final Object object, final Object[] objectArray, IHookable iHookable, final Method method, ITestResult iTestResult) throws Throwable {
        final Throwable[] throwableArray = new Throwable[1];
        IHookCallBack iHookCallBack = new IHookCallBack(){

            @Override
            public void runTestMethod(ITestResult iTestResult) {
                try {
                    MethodInvocationHelper.invokeMethod(method, object, objectArray);
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                    iTestResult.setThrowable(throwable);
                }
            }

            @Override
            public Object[] getParameters() {
                return objectArray;
            }
        };
        iHookable.run(iHookCallBack, iTestResult);
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }

    protected static void invokeWithTimeout(ITestNGMethod iTestNGMethod, Object object, Object[] objectArray, ITestResult iTestResult) throws InterruptedException, ThreadExecutionException {
        MethodInvocationHelper.invokeWithTimeout(iTestNGMethod, object, objectArray, iTestResult, null);
    }

    protected static void invokeWithTimeout(ITestNGMethod iTestNGMethod, Object object, Object[] objectArray, ITestResult iTestResult, IHookable iHookable) throws InterruptedException, ThreadExecutionException {
        if (ThreadUtil.isTestNGThread() && iTestResult.getTestContext().getCurrentXmlTest().getParallel() != XmlSuite.ParallelMode.TESTS) {
            MethodInvocationHelper.invokeWithTimeoutWithNoExecutor(iTestNGMethod, object, objectArray, iTestResult, iHookable);
        } else {
            MethodInvocationHelper.invokeWithTimeoutWithNewExecutor(iTestNGMethod, object, objectArray, iTestResult, iHookable);
        }
    }

    private static void invokeWithTimeoutWithNoExecutor(ITestNGMethod iTestNGMethod, Object object, Object[] objectArray, ITestResult iTestResult, IHookable iHookable) {
        InvokeMethodRunnable invokeMethodRunnable = new InvokeMethodRunnable(iTestNGMethod, object, objectArray, iHookable, iTestResult);
        try {
            invokeMethodRunnable.run();
            iTestResult.setStatus(1);
        }
        catch (Exception exception) {
            iTestResult.setThrowable(exception.getCause());
            iTestResult.setStatus(2);
        }
    }

    private static void invokeWithTimeoutWithNewExecutor(ITestNGMethod iTestNGMethod, Object object, Object[] objectArray, ITestResult iTestResult, IHookable iHookable) throws InterruptedException, ThreadExecutionException {
        IExecutor iExecutor = ThreadUtil.createExecutor(1, iTestNGMethod.getMethodName());
        InvokeMethodRunnable invokeMethodRunnable = new InvokeMethodRunnable(iTestNGMethod, object, objectArray, iHookable, iTestResult);
        IFutureResult iFutureResult = iExecutor.submitRunnable(invokeMethodRunnable);
        iExecutor.shutdown();
        long l = MethodHelper.calculateTimeOut(iTestNGMethod);
        boolean bl = iExecutor.awaitTermination(l);
        if (!bl) {
            iExecutor.stopNow();
            ThreadTimeoutException threadTimeoutException = new ThreadTimeoutException("Method " + iTestNGMethod.getQualifiedName() + "() didn't finish within the time-out " + l);
            threadTimeoutException.setStackTrace(iExecutor.getStackTraces()[0]);
            iTestResult.setThrowable(threadTimeoutException);
            iTestResult.setStatus(2);
        } else {
            Utils.log("Invoker " + Thread.currentThread().hashCode(), 3, "Method " + iTestNGMethod.getMethodName() + " completed within the time-out " + iTestNGMethod.getTimeOut());
            iFutureResult.get();
            iTestResult.setStatus(1);
        }
    }

    protected static void invokeConfigurable(final Object object, final Object[] objectArray, IConfigurable iConfigurable, final Method method, ITestResult iTestResult) throws Throwable {
        final Throwable[] throwableArray = new Throwable[1];
        IConfigureCallBack iConfigureCallBack = new IConfigureCallBack(){

            @Override
            public void runConfigurationMethod(ITestResult iTestResult) {
                try {
                    MethodInvocationHelper.invokeMethod(method, object, objectArray);
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                    iTestResult.setThrowable(throwable);
                }
            }

            @Override
            public Object[] getParameters() {
                return objectArray;
            }
        };
        iConfigurable.run(iConfigureCallBack, iTestResult);
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }
}

