/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.regex.Pattern;
import org.testng.IExpectedExceptionsHolder;
import org.testng.ITestNGMethod;
import org.testng.annotations.IExpectedExceptionsAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;

public class RegexpExpectedExceptionsHolder
implements IExpectedExceptionsHolder {
    public static final String DEFAULT_REGEXP = ".*";
    private final IAnnotationFinder finder;
    private final ITestNGMethod method;

    public RegexpExpectedExceptionsHolder(IAnnotationFinder iAnnotationFinder, ITestNGMethod iTestNGMethod) {
        this.finder = iAnnotationFinder;
        this.method = iTestNGMethod;
    }

    @Override
    public boolean isThrowableMatching(Throwable throwable) {
        String string = this.getRegExp();
        if (DEFAULT_REGEXP.equals(string)) {
            return true;
        }
        String string2 = throwable.getMessage();
        return string2 != null && Pattern.compile(string, 32).matcher(string2).matches();
    }

    @Override
    public String getWrongExceptionMessage(Throwable throwable) {
        return "The exception was thrown with the wrong message: expected \"" + this.getRegExp() + "\" but got \"" + throwable.getMessage() + "\"";
    }

    private String getRegExp() {
        IExpectedExceptionsAnnotation iExpectedExceptionsAnnotation = this.finder.findAnnotation(this.method, IExpectedExceptionsAnnotation.class);
        if (iExpectedExceptionsAnnotation != null) {
            return DEFAULT_REGEXP;
        }
        ITestAnnotation iTestAnnotation = this.finder.findAnnotation(this.method, ITestAnnotation.class);
        if (iTestAnnotation != null) {
            return iTestAnnotation.getExpectedExceptionsMessageRegExp();
        }
        return DEFAULT_REGEXP;
    }
}

