/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.testng.TestNGException;
import org.testng.internal.reflect.ReflectionRecipes;

public class MethodMatcherException
extends TestNGException {
    public MethodMatcherException(String string, Method method, Object[] objectArray) {
        this(MethodMatcherException.generateMessage(string, method, objectArray));
    }

    public MethodMatcherException(String string) {
        super(string);
    }

    public MethodMatcherException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public MethodMatcherException(Throwable throwable) {
        super(throwable);
    }

    private static String generateMessage(String string, Method method, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("\n").append("Method: ");
        if (method != null) {
            Object[] objectArray2 = ReflectionRecipes.getMethodParameters(method);
            stringBuilder.append(method.getName()).append("(").append(Arrays.toString(objectArray2)).append(")");
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("\n").append("Arguments: ");
        if (objectArray != null) {
            stringBuilder.append("[");
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object != null) {
                    stringBuilder.append("(").append(object.getClass().getName()).append(")").append(object);
                } else {
                    stringBuilder.append("null");
                }
                if (i >= objectArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("Arguments: null");
        }
        return stringBuilder.toString();
    }
}

