/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.List;
import org.testng.ISuite;
import org.testng.ITestResult;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BasePanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.ResultsByClass;
import org.testng.util.Strings;

public class SuitePanel
extends BasePanel {
    private static final String PASSED = "passed";
    private static final String SKIPPED = "skipped";
    private static final String FAILED = "failed";

    public SuitePanel(Model model) {
        super(model);
    }

    @Override
    public void generate(XMLStringBuffer xMLStringBuffer) {
        for (ISuite iSuite : this.getSuites()) {
            this.generateSuitePanel(iSuite, xMLStringBuffer);
        }
    }

    private void generateSuitePanel(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        String string = SuitePanel.suiteToTag(iSuite);
        xMLStringBuffer.push("div", "class", "panel " + string, "panel-name", "suite-" + string);
        String[] stringArray = new String[]{FAILED, SKIPPED, PASSED};
        ResultsByClass[] resultsByClassArray = new ResultsByClass[]{this.getModel().getFailedResultsByClass(iSuite), this.getModel().getSkippedResultsByClass(iSuite), this.getModel().getPassedResultsByClass(iSuite)};
        for (int i = 0; i < resultsByClassArray.length; ++i) {
            ResultsByClass resultsByClass = resultsByClassArray[i];
            for (Class<?> clazz : resultsByClass.getClasses()) {
                this.generateClassPanel(clazz, resultsByClass.getResults(clazz), xMLStringBuffer, stringArray[i], iSuite);
            }
        }
        xMLStringBuffer.pop("div");
    }

    private void generateClassPanel(Class clazz, List<ITestResult> list, XMLStringBuffer xMLStringBuffer, String string, ISuite iSuite) {
        xMLStringBuffer.push("div", "class", "suite-" + SuitePanel.suiteToTag(iSuite) + "-class-" + string);
        xMLStringBuffer.push("div", "class", "main-panel-header rounded-window-top");
        xMLStringBuffer.addEmptyElement("img", "src", Model.getImage(string));
        xMLStringBuffer.addOptional("span", clazz.getName(), "class", "class-name");
        xMLStringBuffer.pop("div");
        xMLStringBuffer.push("div", "class", "main-panel-content rounded-window-bottom");
        for (ITestResult iTestResult : list) {
            this.generateMethod(iTestResult, xMLStringBuffer);
        }
        xMLStringBuffer.pop("div");
        xMLStringBuffer.pop("div");
    }

    private void generateMethod(ITestResult iTestResult, XMLStringBuffer xMLStringBuffer) {
        CharSequence charSequence;
        xMLStringBuffer.push("div", "class", "method");
        xMLStringBuffer.push("div", "class", "method-content");
        xMLStringBuffer.push("a", "name", Model.getTestResultName(iTestResult));
        xMLStringBuffer.pop("a");
        xMLStringBuffer.addOptional("span", iTestResult.getMethod().getMethodName(), "class", "method-name");
        if (iTestResult.getParameters().length > 0) {
            charSequence = new StringBuilder();
            boolean bl = true;
            for (Object object : iTestResult.getParameters()) {
                if (!bl) {
                    ((StringBuilder)charSequence).append(", ");
                }
                bl = false;
                ((StringBuilder)charSequence).append(Utils.toString(object));
            }
            xMLStringBuffer.addOptional("span", "(" + ((StringBuilder)charSequence).toString() + ")", "class", "parameters");
        }
        if (iTestResult.getStatus() != 1 && iTestResult.getThrowable() != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(Utils.stackTrace(iTestResult.getThrowable(), true)[0]);
            xMLStringBuffer.addOptional("div", ((StringBuilder)charSequence).toString() + "\n", "class", "stack-trace");
        }
        if (!Strings.isNullOrEmpty((String)(charSequence = iTestResult.getMethod().getDescription()))) {
            xMLStringBuffer.push("em");
            xMLStringBuffer.addString("(" + (String)charSequence + ")");
            xMLStringBuffer.pop("em");
        }
        xMLStringBuffer.pop("div");
        xMLStringBuffer.pop("div");
    }
}

