/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class IntersectStatsRule
extends SimpleStatsRule<IntersectNode> {
    private static final Pattern<IntersectNode> PATTERN = Patterns.intersect();

    public IntersectStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<IntersectNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(IntersectNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        Preconditions.checkArgument((!node.getSources().isEmpty() ? 1 : 0) != 0, (Object)"Empty intersection is not supported");
        Optional<PlanNodeStatsEstimate> estimate = Optional.empty();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = (PlanNode)node.getSources().get(i);
            PlanNodeStatsEstimate sourceStats = statsProvider.getStats(source);
            PlanNodeStatsEstimate sourceStatsWithMappedSymbols = this.mapToOutputSymbols(sourceStats, node, i);
            estimate = estimate.isPresent() ? Optional.of(PlanNodeStatsEstimateMath.addStatsAndIntersect(estimate.get(), sourceStatsWithMappedSymbols)) : Optional.of(sourceStatsWithMappedSymbols);
        }
        return estimate;
    }

    private PlanNodeStatsEstimate mapToOutputSymbols(PlanNodeStatsEstimate estimate, IntersectNode node, int index) {
        PlanNodeStatsEstimate.Builder mapped = PlanNodeStatsEstimate.builder().setOutputRowCount(estimate.getOutputRowCount());
        node.getOutputVariables().forEach(variable -> mapped.addVariableStatistics((VariableReferenceExpression)variable, estimate.getVariableStatistics((VariableReferenceExpression)((List)node.getVariableMapping().get(variable)).get(index))));
        return mapped.build();
    }
}

