/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class NodeTaskMap {
    private static final Logger log = Logger.get(NodeTaskMap.class);
    private final ConcurrentHashMap<InternalNode, NodeTasks> nodeTasksMap = new ConcurrentHashMap();
    private final FinalizerService finalizerService;

    @Inject
    public NodeTaskMap(FinalizerService finalizerService) {
        this.finalizerService = Objects.requireNonNull(finalizerService, "finalizerService is null");
    }

    public void addTask(InternalNode node, RemoteTask task) {
        this.createOrGetNodeTasks(node).addTask(task);
    }

    public int getPartitionedSplitsOnNode(InternalNode node) {
        return this.createOrGetNodeTasks(node).getPartitionedSplitCount();
    }

    public long getNodeTotalMemoryUsageInBytes(InternalNode node) {
        return this.createOrGetNodeTasks(node).getTotalMemoryUsageInBytes();
    }

    public double getNodeCpuUtilizationPercentage(InternalNode node) {
        return this.createOrGetNodeTasks(node).getTotalCpuTimePerMillis();
    }

    public NodeStatsTracker createTaskStatsTracker(InternalNode node, TaskId taskId) {
        return this.createOrGetNodeTasks(node).createTaskStatsTrackers(taskId);
    }

    private NodeTasks createOrGetNodeTasks(InternalNode node) {
        return this.nodeTasksMap.computeIfAbsent(node, key -> new NodeTasks(this.finalizerService));
    }

    public static interface CumulativeStatsConsumer {
        public void accept(long var1, long var3);
    }

    public static class NodeStatsTracker {
        private final IntConsumer splitSetter;
        private final LongConsumer memoryUsageSetter;
        private final CumulativeStatsConsumer cpuUsageSetter;

        public NodeStatsTracker(IntConsumer splitSetter, LongConsumer memoryUsageSetter, CumulativeStatsConsumer cpuUsageSetter) {
            this.splitSetter = Objects.requireNonNull(splitSetter, "splitSetter is null");
            this.memoryUsageSetter = Objects.requireNonNull(memoryUsageSetter, "memoryUsageSetter is null");
            this.cpuUsageSetter = Objects.requireNonNull(cpuUsageSetter, "cpuUsageSetter is null");
        }

        public void setPartitionedSplitCount(int partitionedSplitCount) {
            this.splitSetter.accept(partitionedSplitCount);
        }

        public void setMemoryUsage(long memoryUsage) {
            this.memoryUsageSetter.accept(memoryUsage);
        }

        public void setCpuUsage(long age, long cpuUsage) {
            this.cpuUsageSetter.accept(age, cpuUsage);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("splitSetter", (Object)this.splitSetter.toString()).add("memoryUsageSetter", (Object)this.memoryUsageSetter.toString()).add("cpuUsageSetter", (Object)this.cpuUsageSetter.toString()).toString();
        }
    }

    private static class NodeTasks {
        private final Set<RemoteTask> remoteTasks = Sets.newConcurrentHashSet();
        private final AtomicLong nodeTotalPartitionedSplitCount = new AtomicLong();
        private final AtomicLong nodeTotalMemoryUsageInBytes = new AtomicLong();
        private final AtomicDouble nodeTotalCpuTimePerMillis = new AtomicDouble();
        private final FinalizerService finalizerService;

        public NodeTasks(FinalizerService finalizerService) {
            this.finalizerService = Objects.requireNonNull(finalizerService, "finalizerService is null");
        }

        private int getPartitionedSplitCount() {
            return this.nodeTotalPartitionedSplitCount.intValue();
        }

        private long getTotalMemoryUsageInBytes() {
            return this.nodeTotalMemoryUsageInBytes.get();
        }

        private double getTotalCpuTimePerMillis() {
            return this.nodeTotalCpuTimePerMillis.get();
        }

        private void addTask(RemoteTask task) {
            if (this.remoteTasks.add(task)) {
                task.addStateChangeListener(taskStatus -> {
                    if (taskStatus.getState().isDone()) {
                        this.remoteTasks.remove(task);
                    }
                });
                if (task.getTaskStatus().getState().isDone()) {
                    this.remoteTasks.remove(task);
                }
            }
        }

        public NodeStatsTracker createTaskStatsTrackers(TaskId taskId) {
            Objects.requireNonNull(taskId, "taskId is null");
            TaskStatsTracker splitTracker = new TaskStatsTracker("SplitTracker", taskId, this.nodeTotalPartitionedSplitCount);
            TaskStatsTracker memoryUsageTracker = new TaskStatsTracker("MemoryTracker", taskId, this.nodeTotalMemoryUsageInBytes);
            AccumulatedTaskStatsTracker cpuUtilizationPercentageTracker = new AccumulatedTaskStatsTracker("CpuTracker", taskId, this.nodeTotalCpuTimePerMillis);
            NodeStatsTracker nodeStatsTracker = new NodeStatsTracker(splitTracker::setValue, memoryUsageTracker::setValue, cpuUtilizationPercentageTracker::setValue);
            this.finalizerService.addFinalizer(nodeStatsTracker, () -> {
                splitTracker.cleanup();
                memoryUsageTracker.cleanup();
                cpuUtilizationPercentageTracker.cleanup();
            });
            return nodeStatsTracker;
        }

        @ThreadSafe
        private static class AccumulatedTaskStatsTracker {
            private final String counterName;
            private final TaskId taskId;
            private final AtomicDouble totalValue;
            private final AtomicDouble localValue = new AtomicDouble();
            private long previousTaskAge;
            private long previousValue;

            AccumulatedTaskStatsTracker(String counterName, TaskId taskId, AtomicDouble totalValue) {
                this.counterName = Objects.requireNonNull(counterName, "counterName is null");
                this.taskId = Objects.requireNonNull(taskId, "taskId is null");
                this.totalValue = Objects.requireNonNull(totalValue, "totalValue is null");
            }

            private double getDeltaPerSecond(long taskAgeInMillis, long value) {
                if (this.previousTaskAge == 0L && value > 0L) {
                    this.previousTaskAge = taskAgeInMillis;
                    this.previousValue = value;
                    return 0.0;
                }
                if (taskAgeInMillis <= this.previousTaskAge) {
                    return 0.0;
                }
                if (value > 0L) {
                    double deltaValue = (value - this.previousValue) * 100L;
                    long deltaDuration = taskAgeInMillis - this.previousTaskAge;
                    this.previousTaskAge = taskAgeInMillis;
                    this.previousValue = value;
                    return deltaValue > 0.0 ? deltaValue / (double)deltaDuration : 0.0;
                }
                return 0.0;
            }

            public synchronized void setValue(long taskAgeInMillis, long value) {
                double delta = this.getDeltaPerSecond(taskAgeInMillis, value);
                if (delta < 0.0) {
                    double oldValue = this.localValue.getAndSet(0.0);
                    this.totalValue.addAndGet(-oldValue);
                    throw new IllegalArgumentException(this.counterName + " is negative");
                }
                double oldValue = this.localValue.getAndSet(delta);
                this.totalValue.addAndGet(delta - oldValue);
            }

            public void cleanup() {
                double leakedValues = this.localValue.getAndSet(0.0);
                if (leakedValues == 0.0) {
                    return;
                }
                log.error("BUG! %s for %s leaked with %s %s.  Cleaning up so server can continue to function.", new Object[]{this.getClass().getName(), this.taskId, leakedValues, this.counterName});
                this.totalValue.addAndGet(-leakedValues);
            }
        }

        @ThreadSafe
        private static class TaskStatsTracker {
            private final String counterName;
            private final TaskId taskId;
            private final AtomicLong totalValue;
            private final AtomicLong localValue = new AtomicLong();

            public TaskStatsTracker(String counterName, TaskId taskId, AtomicLong totalValue) {
                this.counterName = Objects.requireNonNull(counterName, "counterName is null");
                this.taskId = Objects.requireNonNull(taskId, "taskId is null");
                this.totalValue = Objects.requireNonNull(totalValue, "totalValue is null");
            }

            public synchronized void setValue(long value) {
                if (value < 0L) {
                    long oldValue = this.localValue.getAndSet(0L);
                    this.totalValue.addAndGet(-oldValue);
                    throw new IllegalArgumentException(this.counterName + " is negative");
                }
                long oldValue = this.localValue.getAndSet(value);
                this.totalValue.addAndGet(value - oldValue);
            }

            public void cleanup() {
                long leakedValues = this.localValue.getAndSet(0L);
                if (leakedValues == 0L) {
                    return;
                }
                log.error("BUG! %s for %s leaked with %s %s.  Cleaning up so server can continue to function.", new Object[]{this.getClass().getName(), this.taskId, leakedValues, this.counterName});
                this.totalValue.addAndGet(-leakedValues);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add(this.counterName, (Object)this.localValue).toString();
            }
        }
    }
}

