/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.MemoryRevokingUtils;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManagementExecutor;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.TaskRevocableMemoryListener;
import com.facebook.presto.memory.VoidTraversingQueryContextVisitor;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class TaskThresholdMemoryRevokingScheduler {
    private static final Logger log = Logger.get(TaskThresholdMemoryRevokingScheduler.class);
    private final Supplier<List<SqlTask>> allTasksSupplier;
    private final Function<TaskId, SqlTask> taskSupplier;
    private final ScheduledExecutorService taskManagementExecutor;
    private final long maxRevocableMemoryPerTask;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    private final AtomicBoolean checkPending = new AtomicBoolean();
    private final List<MemoryPool> memoryPools;
    private final TaskRevocableMemoryListener taskRevocableMemoryListener = this::onMemoryReserved;

    @Inject
    public TaskThresholdMemoryRevokingScheduler(LocalMemoryManager localMemoryManager, SqlTaskManager sqlTaskManager, TaskManagementExecutor taskManagementExecutor, FeaturesConfig config) {
        this((List<MemoryPool>)ImmutableList.copyOf(MemoryRevokingUtils.getMemoryPools(localMemoryManager)), Objects.requireNonNull(sqlTaskManager, "sqlTaskManager cannot be null")::getAllTasks, Objects.requireNonNull(sqlTaskManager, "sqlTaskManager cannot be null")::getTask, Objects.requireNonNull(taskManagementExecutor, "taskManagementExecutor cannot be null").getExecutor(), Objects.requireNonNull(config.getMaxRevocableMemoryPerTask(), "maxRevocableMemoryPerTask cannot be null").toBytes());
        log.debug("Using TaskThresholdMemoryRevokingScheduler spilling strategy");
    }

    @VisibleForTesting
    TaskThresholdMemoryRevokingScheduler(List<MemoryPool> memoryPools, Supplier<List<SqlTask>> allTasksSupplier, Function<TaskId, SqlTask> taskSupplier, ScheduledExecutorService taskManagementExecutor, long maxRevocableMemoryPerTask) {
        this.memoryPools = ImmutableList.copyOf((Collection)Objects.requireNonNull(memoryPools, "memoryPools is null"));
        this.allTasksSupplier = Objects.requireNonNull(allTasksSupplier, "allTasksSupplier is null");
        this.taskSupplier = Objects.requireNonNull(taskSupplier, "taskSupplier is null");
        this.taskManagementExecutor = Objects.requireNonNull(taskManagementExecutor, "taskManagementExecutor is null");
        this.maxRevocableMemoryPerTask = maxRevocableMemoryPerTask;
    }

    @PostConstruct
    public void start() {
        this.registerTaskMemoryPeriodicCheck();
        this.registerPoolListeners();
    }

    private void registerTaskMemoryPeriodicCheck() {
        this.scheduledFuture = this.taskManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.revokeHighMemoryTasksIfNeeded();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error requesting task memory revoking");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.memoryPools.forEach(memoryPool -> memoryPool.removeTaskRevocableMemoryListener(this.taskRevocableMemoryListener));
    }

    @VisibleForTesting
    void registerPoolListeners() {
        this.memoryPools.forEach(memoryPool -> memoryPool.addTaskRevocableMemoryListener(this.taskRevocableMemoryListener));
    }

    @VisibleForTesting
    void revokeHighMemoryTasksIfNeeded() {
        if (this.checkPending.compareAndSet(false, true)) {
            this.revokeHighMemoryTasks();
        }
    }

    private void onMemoryReserved(TaskId taskId) {
        try {
            SqlTask task = this.taskSupplier.apply(taskId);
            if (!this.memoryRevokingNeeded(task)) {
                return;
            }
            if (this.checkPending.compareAndSet(false, true)) {
                log.debug("Scheduling check for %s", new Object[]{taskId});
                this.scheduleRevoking();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error when acting on memory pool reservation");
        }
    }

    private void scheduleRevoking() {
        this.taskManagementExecutor.execute(() -> {
            try {
                this.revokeHighMemoryTasks();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error requesting memory revoking");
            }
        });
    }

    private boolean memoryRevokingNeeded(SqlTask task) {
        return task.getTaskContext().filter(taskContext -> taskContext.getTaskMemoryContext().getRevocableMemory() >= this.maxRevocableMemoryPerTask).isPresent();
    }

    private synchronized void revokeHighMemoryTasks() {
        if (this.checkPending.getAndSet(false)) {
            Collection sqlTasks = Objects.requireNonNull(this.allTasksSupplier.get());
            for (final SqlTask task : sqlTasks) {
                long currentTaskRevocableMemory;
                Optional<TaskContext> taskContext = task.getTaskContext();
                if (!taskContext.isPresent() || (currentTaskRevocableMemory = taskContext.get().getTaskMemoryContext().getRevocableMemory()) < this.maxRevocableMemoryPerTask) continue;
                AtomicLong remainingBytesToRevokeAtomic = new AtomicLong(currentTaskRevocableMemory - this.maxRevocableMemoryPerTask);
                taskContext.get().accept(new VoidTraversingQueryContextVisitor<AtomicLong>(){

                    @Override
                    public Void visitOperatorContext(OperatorContext operatorContext, AtomicLong remainingBytesToRevoke) {
                        long revokedBytes;
                        if (remainingBytesToRevoke.get() > 0L && (revokedBytes = operatorContext.requestMemoryRevoking()) > 0L) {
                            remainingBytesToRevoke.addAndGet(-revokedBytes);
                            log.debug("taskId=%s: requested revoking %s; remaining %s", new Object[]{task.getTaskId(), revokedBytes, remainingBytesToRevoke.get()});
                        }
                        return null;
                    }
                }, remainingBytesToRevokeAtomic);
            }
        }
    }
}

