/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PageDataOutput;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.storage.TempDataOperationContext;
import com.facebook.presto.spi.storage.TempDataSink;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.spi.storage.TempStorageHandle;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;

public class SpoolingOutputBuffer
implements OutputBuffer {
    private final TaskId taskId;
    private final String taskInstanceId;
    private final OutputBuffers outputBuffers;
    private final StateMachine<BufferState> state;
    private final TempDataOperationContext tempDataOperationContext;
    private final TempStorage tempStorage;
    private final DataSize threshold;
    private final FinalizerService finalizerService;
    private final ListeningExecutorService executor;
    private final AtomicLong totalBufferedBytes = new AtomicLong();
    private final AtomicLong totalBufferedPages = new AtomicLong();
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();
    private final OutputBuffers.OutputBufferId outputBufferId = new OutputBuffers.OutputBufferId(0);
    private static final Logger log = Logger.get(SpoolingOutputBuffer.class);
    private final AtomicBoolean noMorePages = new AtomicBoolean();
    private final AtomicLong currentMemorySequenceId = new AtomicLong();
    private final AtomicLong currentSequenceId = new AtomicLong();
    private final AtomicLong startPage = new AtomicLong();
    private final AtomicLong totalPagesRemaining = new AtomicLong();
    private final AtomicLong totalInMemoryBytes = new AtomicLong();
    private final AtomicLong peakMemoryUsage = new AtomicLong();
    private final AtomicLong totalStorageBytesAdded = new AtomicLong();
    private final AtomicLong totalStoragePagesAdded = new AtomicLong();
    @GuardedBy(value="this")
    private final Deque<HandleInfo> handleInfoQueue = new LinkedList<HandleInfo>();
    @GuardedBy(value="this")
    private final Queue<SerializedPage> pages = new ArrayDeque<SerializedPage>();
    @GuardedBy(value="this")
    private PendingRead pendingRead;

    public SpoolingOutputBuffer(TaskId taskId, String taskInstanceId, OutputBuffers outputBuffers, StateMachine<BufferState> state, TempStorage tempStorage, DataSize threshold, ListeningExecutorService executor, FinalizerService finalizerService) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceIs is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.tempStorage = Objects.requireNonNull(tempStorage, "tempStorage is null");
        this.threshold = Objects.requireNonNull(threshold, "threshold is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.finalizerService = Objects.requireNonNull(finalizerService, "finalizerService is null");
        this.finalizerService.addFinalizer(this, this::close);
        this.tempDataOperationContext = new TempDataOperationContext(Optional.empty(), taskId.getQueryId().toString(), Optional.empty(), new Identity("spooling-buffer", Optional.empty()));
        state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
    }

    @Override
    public OutputBufferInfo getInfo() {
        return new OutputBufferInfo("SPOOLING", this.state.get(), this.state.get().canAddBuffers(), this.state.get().canAddPages(), this.totalBufferedBytes.get(), this.totalBufferedPages.get(), this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)ImmutableList.of());
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return (double)this.totalInMemoryBytes.get() / (double)this.threshold.toBytes();
    }

    @Override
    public boolean isOverutilized() {
        return this.totalInMemoryBytes.get() > this.threshold.toBytes();
    }

    @Override
    public long getPeakMemoryUsage() {
        return this.peakMemoryUsage.get();
    }

    @Override
    public ListenableFuture<?> isFull() {
        return Futures.immediateFuture(null);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        Preconditions.checkArgument((this.outputBuffers.getType() == OutputBuffers.BufferType.SPOOLING ? 1 : 0) != 0, (Object)"Invalid output buffers type");
        Preconditions.checkArgument((boolean)this.outputBuffers.isNoMoreBufferIds(), (Object)"invalid noMoreBufferIds");
        if (this.state.get().isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
            return;
        }
        this.outputBuffers.checkValidTransition(newOutputBuffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
        PendingRead pendingRead;
        if (!this.state.get().canAddPages()) {
            return;
        }
        SpoolingOutputBuffer spoolingOutputBuffer = this;
        synchronized (spoolingOutputBuffer) {
            this.pages.addAll(pages);
            long bytesAdded = this.getPagesSize(pages);
            long pagesAdded = pages.size();
            this.totalBufferedBytes.addAndGet(bytesAdded);
            this.totalBufferedPages.addAndGet(pagesAdded);
            this.totalPagesAdded.addAndGet(pagesAdded);
            this.totalRowsAdded.addAndGet(this.getPagesRows(pages));
            this.totalInMemoryBytes.addAndGet(bytesAdded);
            this.totalPagesRemaining.addAndGet(pagesAdded);
            this.peakMemoryUsage.accumulateAndGet(this.totalInMemoryBytes.get(), Math::max);
            if (this.totalInMemoryBytes.get() >= this.threshold.toBytes()) {
                this.flush();
            }
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        if (pendingRead != null) {
            this.processPendingRead(pendingRead);
        }
    }

    @Override
    public synchronized void enqueue(Lifespan lifespan, int partition, List<SerializedPage> pages) {
        Preconditions.checkState((partition == 0 ? 1 : 0) != 0, (Object)"Expected partition number to be zero");
        this.enqueue(lifespan, pages);
    }

    private synchronized void flush() {
        List dataOutputs = (List)this.pages.stream().map(PageDataOutput::new).collect(ImmutableList.toImmutableList());
        ListenableFuture handleFuture = this.executor.submit(() -> {
            TempDataSink dataSink = this.tempStorage.create(this.tempDataOperationContext);
            dataSink.write(dataOutputs);
            return dataSink.commit();
        });
        long bytes = this.totalInMemoryBytes.get();
        int pageCount = this.pages.size();
        HandleInfo handleInfo = new HandleInfo((Range<Long>)Range.closedOpen((Comparable)Long.valueOf(this.currentMemorySequenceId.get()), (Comparable)Long.valueOf(this.currentMemorySequenceId.get() + (long)pageCount)), (ListenableFuture<TempStorageHandle>)handleFuture, bytes, pageCount);
        this.handleInfoQueue.add(handleInfo);
        this.currentMemorySequenceId.addAndGet(pageCount);
        this.pages.clear();
        this.totalStorageBytesAdded.addAndGet(bytes);
        this.totalStoragePagesAdded.addAndGet(pageCount);
        this.totalInMemoryBytes.set(0L);
    }

    @Override
    public synchronized ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long startSequenceId, DataSize maxSize) {
        Objects.requireNonNull(bufferId, "outputBufferId is null");
        Preconditions.checkArgument((bufferId.getId() == this.outputBufferId.getId() ? 1 : 0) != 0, (Object)"Invalid buffer id");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        this.acknowledge(bufferId, startSequenceId);
        long currentSequenceId = this.currentSequenceId.get();
        if (this.noMorePages.get() || !this.handleInfoQueue.isEmpty() || !this.pages.isEmpty() || currentSequenceId != startSequenceId) {
            return this.processRead(startSequenceId, maxSize);
        }
        PendingRead oldPendingRead = this.pendingRead;
        this.pendingRead = new PendingRead(this.taskInstanceId, currentSequenceId, maxSize);
        if (oldPendingRead != null) {
            oldPendingRead.completeResultFutureWithEmpty();
        }
        return this.pendingRead.getResultFuture();
    }

    private void processPendingRead(PendingRead pendingRead) {
        if (pendingRead.getResultFuture().isDone()) {
            return;
        }
        ListenableFuture<BufferResult> resultFuture = this.processRead(pendingRead.getStartSequenceId(), pendingRead.getMaxSize());
        pendingRead.setResultFuture(resultFuture);
    }

    private synchronized ListenableFuture<BufferResult> processRead(long startSequenceId, DataSize maxSize) {
        long currentSequenceId = this.currentSequenceId.get();
        if (startSequenceId < currentSequenceId) {
            return Futures.immediateFuture((Object)BufferResult.emptyResults(this.taskInstanceId, startSequenceId, false));
        }
        if (this.noMorePages.get() && this.handleInfoQueue.isEmpty() && this.pages.isEmpty()) {
            return Futures.immediateFuture((Object)BufferResult.emptyResults(this.taskInstanceId, startSequenceId, true));
        }
        Preconditions.checkState((currentSequenceId == startSequenceId ? 1 : 0) != 0, (Object)"Invalid startSequenceId");
        ImmutableList handleInfos = ImmutableList.copyOf(this.handleInfoQueue);
        ImmutableList pages = ImmutableList.copyOf(this.pages);
        GetTracker getTracker = new GetTracker(maxSize, (List)handleInfos, (List)pages, Math.toIntExact(this.startPage.get()));
        long maxBytes = maxSize.toBytes();
        ListenableFuture<List<SerializedPage>> storagePages = this.getPagesFromStorage(startSequenceId, getTracker);
        ListenableFuture memoryPages = Futures.transform(storagePages, input -> {
            long pageCount = getTracker.getPageCount();
            long bytes = getTracker.getBytes();
            long startMemorySequenceId = startSequenceId + pageCount;
            if (startMemorySequenceId == this.currentMemorySequenceId.get() && (bytes < maxBytes || input.isEmpty())) {
                ImmutableList.Builder combinedPages = ImmutableList.builder();
                combinedPages.addAll((Iterable)input);
                combinedPages.addAll(this.getPagesFromMemory(startMemorySequenceId, getTracker));
                return combinedPages.build();
            }
            return input;
        }, (Executor)this.executor);
        ListenableFuture resultFuture = Futures.transform((ListenableFuture)memoryPages, input -> {
            long newSequenceId = startSequenceId + (long)input.size();
            return new BufferResult(this.taskInstanceId, startSequenceId, newSequenceId, false, (List<SerializedPage>)input);
        }, (Executor)this.executor);
        return Futures.catchingAsync((ListenableFuture)resultFuture, Exception.class, e -> {
            log.error("Task %s: Failed to get page with startSequenceId %s", new Object[]{this.taskId, startSequenceId});
            return Futures.immediateFailedFuture((Throwable)e);
        }, (Executor)this.executor);
    }

    private ListenableFuture<List<SerializedPage>> getPagesFromStorage(long startSequenceId, GetTracker getTracker) {
        if (startSequenceId >= this.currentMemorySequenceId.get()) {
            return Futures.immediateFuture((Object)ImmutableList.of());
        }
        Iterator handleInfoIterator = getTracker.getHandleInfos().iterator();
        HandleInfo handleInfo = (HandleInfo)handleInfoIterator.next();
        ListenableFuture<TempStorageHandle> handleFuture = handleInfo.getHandleFuture();
        return Futures.transformAsync(handleFuture, input -> this.getPagesFromStorage((ImmutableList.Builder<SerializedPage>)ImmutableList.builder(), handleInfoIterator, (TempStorageHandle)input, getTracker), (Executor)this.executor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ListenableFuture<List<SerializedPage>> getPagesFromStorage(ImmutableList.Builder<SerializedPage> resultBuilder, Iterator<HandleInfo> handleIterator, TempStorageHandle handle, GetTracker getTracker) {
        long maxBytes = getTracker.getMaxSize().toBytes();
        long bytes = getTracker.getBytes();
        long pageCount = getTracker.getPageCount();
        try (InputStreamSliceInput inputStream = new InputStreamSliceInput(this.tempStorage.open(this.tempDataOperationContext, handle));){
            ListenableFuture listenableFuture;
            Iterator serializedPages = PagesSerdeUtil.readSerializedPages((SliceInput)inputStream);
            Iterators.advance((Iterator)serializedPages, (int)getTracker.getStartPage());
            while (serializedPages.hasNext()) {
                SerializedPage page = (SerializedPage)serializedPages.next();
                long bytesRead = bytes;
                if (pageCount != 0L && (bytes += page.getRetainedSizeInBytes()) > maxBytes) {
                    getTracker.update(bytesRead, pageCount);
                    ListenableFuture listenableFuture2 = Futures.immediateFuture((Object)resultBuilder.build());
                    return listenableFuture2;
                }
                resultBuilder.add((Object)page);
                ++pageCount;
            }
            getTracker.update(bytes, pageCount);
            if (!handleIterator.hasNext()) {
                listenableFuture = Futures.immediateFuture((Object)resultBuilder.build());
                return listenableFuture;
            }
            listenableFuture = Futures.transformAsync(handleIterator.next().getHandleFuture(), input -> this.getPagesFromStorage(resultBuilder, handleIterator, (TempStorageHandle)input, getTracker), (Executor)this.executor);
            return listenableFuture;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SPOOLING_STORAGE_ERROR, "Failed to read file from TempStorage", (Throwable)e);
        }
    }

    private List<SerializedPage> getPagesFromMemory(long startSequenceId, GetTracker getTracker) {
        Preconditions.checkArgument((startSequenceId == this.currentMemorySequenceId.get() ? 1 : 0) != 0, (Object)"Invalid startSequenceId for memory pages");
        Preconditions.checkArgument((getTracker.bytes < getTracker.maxSize.toBytes() ? 1 : 0) != 0, (Object)"bytesRead is greater than maxSize");
        ImmutableList.Builder result = ImmutableList.builder();
        List pages = getTracker.getMemoryPages();
        long maxBytes = getTracker.maxSize.toBytes();
        long bytes = 0L;
        long pageCount = 0L;
        for (SerializedPage page : pages) {
            if (pageCount != 0L && (bytes += page.getRetainedSizeInBytes()) > maxBytes) break;
            result.add((Object)page);
            ++pageCount;
        }
        return result.build();
    }

    @Override
    public synchronized void acknowledge(OutputBuffers.OutputBufferId bufferId, long sequenceId) {
        Preconditions.checkArgument((bufferId.getId() == this.outputBufferId.getId() ? 1 : 0) != 0, (Object)"Invalid buffer id");
        Preconditions.checkArgument((sequenceId >= 0L ? 1 : 0) != 0, (Object)"Invalid sequenceId");
        if (this.state.get() == BufferState.FINISHED || sequenceId < this.currentSequenceId.get()) {
            return;
        }
        long oldSequenceId = this.currentSequenceId.get();
        int pagesToRemove = Math.toIntExact(sequenceId - oldSequenceId);
        long currentSequenceId = oldSequenceId;
        Preconditions.checkArgument(((long)pagesToRemove <= this.totalPagesRemaining.get() ? 1 : 0) != 0, (Object)"Invalid sequenceId");
        if ((currentSequenceId += this.acknowledgePagesFromStorage(sequenceId)) < sequenceId) {
            this.acknowledgePagesFromMemory(sequenceId, currentSequenceId);
        }
        Verify.verify((boolean)this.currentSequenceId.compareAndSet(oldSequenceId, oldSequenceId + (long)pagesToRemove));
    }

    private synchronized long acknowledgePagesFromStorage(long sequenceId) {
        long pagesAcknowledged = 0L;
        long pagesRemoved = 0L;
        long bytesRemoved = 0L;
        ImmutableList handleInfos = ImmutableList.copyOf(this.handleInfoQueue);
        for (HandleInfo handleInfo : handleInfos) {
            Range<Long> range = handleInfo.getRange();
            if ((Long)range.upperEndpoint() <= sequenceId) {
                handleInfo.removeFile();
                this.handleInfoQueue.removeFirst();
                pagesAcknowledged += (long)handleInfo.getPageCount() - this.startPage.get();
                pagesRemoved += (long)handleInfo.getPageCount();
                bytesRemoved += handleInfo.getBytes();
                this.startPage.set(0L);
                continue;
            }
            pagesAcknowledged += sequenceId - (Long)range.lowerEndpoint() - this.startPage.get();
            this.startPage.set(Math.toIntExact(sequenceId - (Long)range.lowerEndpoint()));
            break;
        }
        this.totalBufferedPages.addAndGet(-pagesRemoved);
        this.totalBufferedBytes.addAndGet(-bytesRemoved);
        this.totalPagesRemaining.addAndGet(-pagesAcknowledged);
        return pagesAcknowledged;
    }

    private synchronized void acknowledgePagesFromMemory(long sequenceId, long startSequenceId) {
        Preconditions.checkState((startSequenceId == this.currentMemorySequenceId.get() ? 1 : 0) != 0, (Object)"Invalid startSequenceId for memory pages");
        int pagesToRemove = Math.toIntExact(sequenceId - startSequenceId);
        Preconditions.checkArgument((pagesToRemove <= this.pages.size() ? 1 : 0) != 0, (Object)"Invalid sequenceId");
        long bytesRemoved = 0L;
        for (int i = 0; i < pagesToRemove; ++i) {
            SerializedPage removedPage = this.pages.remove();
            bytesRemoved += removedPage.getRetainedSizeInBytes();
            this.currentMemorySequenceId.incrementAndGet();
        }
        this.totalBufferedPages.addAndGet(-pagesToRemove);
        this.totalBufferedBytes.addAndGet(-bytesRemoved);
        this.totalInMemoryBytes.addAndGet(-bytesRemoved);
        this.totalPagesRemaining.addAndGet(-pagesToRemove);
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        Preconditions.checkArgument((bufferId.getId() == this.outputBufferId.getId() ? 1 : 0) != 0, (Object)"Invalid bufferId");
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoMorePages() {
        PendingRead pendingRead;
        SpoolingOutputBuffer spoolingOutputBuffer = this;
        synchronized (spoolingOutputBuffer) {
            this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
            this.noMorePages.set(true);
            pendingRead = this.pendingRead;
            this.pendingRead = null;
            log.info("Task %s: %s pages and %s bytes was written into TempStorage", new Object[]{this.taskId, this.totalStoragePagesAdded.get(), this.totalStorageBytesAdded.get()});
        }
        if (pendingRead != null) {
            this.processPendingRead(pendingRead);
        }
        this.checkFlushComplete();
    }

    private void checkFlushComplete() {
        if (this.state.get() != BufferState.FLUSHING) {
            return;
        }
        if (this.totalBufferedPages.get() == 0L) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        PendingRead pendingRead;
        SpoolingOutputBuffer spoolingOutputBuffer = this;
        synchronized (spoolingOutputBuffer) {
            if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
                this.close();
            }
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        if (pendingRead != null) {
            pendingRead.completeResultFutureWithEmpty();
        }
    }

    @Override
    public void fail() {
        this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal());
    }

    private synchronized void close() {
        for (HandleInfo handleInfo : this.handleInfoQueue) {
            handleInfo.removeFile();
        }
        this.pages.clear();
        this.handleInfoQueue.clear();
        this.noMorePages.set(true);
        this.totalBufferedPages.set(0L);
        this.totalBufferedBytes.set(0L);
        this.totalPagesRemaining.set(0L);
    }

    @Override
    public void setNoMorePagesForLifespan(Lifespan lifespan) {
    }

    @Override
    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
    }

    @Override
    public boolean isFinishedForLifespan(Lifespan lifespan) {
        return this.isFinished();
    }

    private long getPagesSize(Collection<SerializedPage> pages) {
        return pages.stream().mapToLong(SerializedPage::getRetainedSizeInBytes).sum();
    }

    private long getPagesRows(Collection<SerializedPage> pages) {
        return pages.stream().mapToLong(SerializedPage::getPositionCount).sum();
    }

    private class GetTracker {
        private int startPage;
        private long bytes;
        private long pageCount;
        private final DataSize maxSize;
        private final List<SerializedPage> pages;
        private final List<HandleInfo> handleInfos;

        private GetTracker(DataSize maxSize, List<HandleInfo> handleInfos, List<SerializedPage> pages, int startPage) {
            this.maxSize = Objects.requireNonNull(maxSize, "maxSize is null");
            this.handleInfos = Objects.requireNonNull(handleInfos, "handleInfos is null");
            this.pages = Objects.requireNonNull(pages, "pages is null");
            this.startPage = startPage;
        }

        private void update(long newBytes, long newPageCount) {
            this.bytes = newBytes;
            this.pageCount = newPageCount;
            this.startPage = 0;
        }

        private DataSize getMaxSize() {
            return this.maxSize;
        }

        private int getStartPage() {
            return this.startPage;
        }

        private long getBytes() {
            return this.bytes;
        }

        private long getPageCount() {
            return this.pageCount;
        }

        private List<SerializedPage> getMemoryPages() {
            return this.pages;
        }

        private List<HandleInfo> getHandleInfos() {
            return this.handleInfos;
        }
    }

    @Immutable
    private static class PendingRead {
        private final String taskInstanceId;
        private final long startSequenceId;
        private final DataSize maxSize;
        private final SettableFuture<BufferResult> resultFuture = SettableFuture.create();

        private PendingRead(String taskInstanceId, long startSequenceId, DataSize maxSize) {
            this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
            this.startSequenceId = startSequenceId;
            this.maxSize = Objects.requireNonNull(maxSize, "maxSize is null");
        }

        public long getStartSequenceId() {
            return this.startSequenceId;
        }

        public DataSize getMaxSize() {
            return this.maxSize;
        }

        public ListenableFuture<BufferResult> getResultFuture() {
            return this.resultFuture;
        }

        public void completeResultFutureWithEmpty() {
            this.resultFuture.set((Object)BufferResult.emptyResults(this.taskInstanceId, this.startSequenceId, false));
        }

        public void setResultFuture(ListenableFuture<BufferResult> result) {
            this.resultFuture.setFuture(result);
        }
    }

    private class HandleInfo {
        private final Range<Long> range;
        private final ListenableFuture<TempStorageHandle> handleFuture;
        private final long bytes;
        private final int pageCount;

        public HandleInfo(Range<Long> range, ListenableFuture<TempStorageHandle> handleFuture, long bytes, int pageCount) {
            this.range = Objects.requireNonNull(range, "range is null");
            this.handleFuture = Objects.requireNonNull(handleFuture, "handleFuture is null");
            this.bytes = bytes;
            this.pageCount = pageCount;
        }

        public long getBytes() {
            return this.bytes;
        }

        public int getPageCount() {
            return this.pageCount;
        }

        public Range<Long> getRange() {
            return this.range;
        }

        public ListenableFuture<TempStorageHandle> getHandleFuture() {
            return this.handleFuture;
        }

        public void removeFile() {
            SpoolingOutputBuffer.this.executor.execute(() -> {
                try {
                    SpoolingOutputBuffer.this.tempStorage.remove(SpoolingOutputBuffer.this.tempDataOperationContext, (TempStorageHandle)this.handleFuture.get());
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Failed to remove file from TempStorage");
                }
            });
        }
    }
}

