/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.presto.execution.executor.MultilevelSplitQueue;
import com.facebook.presto.execution.executor.Priority;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public class TaskPriorityTracker {
    private final MultilevelSplitQueue splitQueue;
    @GuardedBy(value="this")
    private long scheduledNanos;
    @GuardedBy(value="this")
    private volatile Priority priority = new Priority(0, 0L);

    public TaskPriorityTracker(MultilevelSplitQueue splitQueue) {
        this.splitQueue = Objects.requireNonNull(splitQueue, "splitQueue is null");
    }

    public synchronized Priority updatePriority(long durationNanos) {
        Priority newPriority;
        this.scheduledNanos += durationNanos;
        this.priority = newPriority = this.splitQueue.updatePriority(this.priority, durationNanos, this.scheduledNanos);
        return newPriority;
    }

    public synchronized Priority resetLevelPriority() {
        long levelMinPriority = this.splitQueue.getLevelMinPriority(this.priority.getLevel(), this.scheduledNanos);
        if (this.priority.getLevelPriority() < levelMinPriority) {
            Priority newPriority;
            this.priority = newPriority = new Priority(this.priority.getLevel(), levelMinPriority);
            return newPriority;
        }
        return this.priority;
    }

    public synchronized long getScheduledNanos() {
        return this.scheduledNanos;
    }

    public synchronized Priority getPriority() {
        return this.priority;
    }
}

