/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.SplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.execution.scheduler.group.DynamicLifespanScheduler;
import com.facebook.presto.execution.scheduler.group.FixedLifespanScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class FixedSourcePartitionedScheduler
implements StageScheduler {
    private static final Logger log = Logger.get(FixedSourcePartitionedScheduler.class);
    private final SqlStageExecution stage;
    private final List<InternalNode> nodes;
    private final List<SourceScheduler> sourceSchedulers;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private boolean scheduledTasks;
    private boolean anySourceSchedulingFinished;
    private final Optional<LifespanScheduler> groupedLifespanScheduler;
    private final Queue<Integer> tasksToRecover = new ConcurrentLinkedQueue<Integer>();
    @GuardedBy(value="this")
    private boolean closed;

    public FixedSourcePartitionedScheduler(SqlStageExecution stage, Map<PlanNodeId, SplitSource> splitSources, StageExecutionDescriptor stageExecutionDescriptor, List<PlanNodeId> schedulingOrder, List<InternalNode> nodes, BucketNodeMap bucketNodeMap, int splitBatchSize, OptionalInt concurrentLifespansPerTask, NodeSelector nodeSelector, List<ConnectorPartitionHandle> partitionHandles) {
        Objects.requireNonNull(stage, "stage is null");
        Objects.requireNonNull(splitSources, "splitSources is null");
        Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        Preconditions.checkArgument((!Objects.requireNonNull(nodes, "nodes is null").isEmpty() ? 1 : 0) != 0, (Object)"nodes is empty");
        Objects.requireNonNull(partitionHandles, "partitionHandles is null");
        this.stage = stage;
        this.nodes = ImmutableList.copyOf(nodes);
        this.partitionHandles = ImmutableList.copyOf(partitionHandles);
        Preconditions.checkArgument((boolean)splitSources.keySet().equals(ImmutableSet.copyOf(schedulingOrder)));
        BucketedSplitPlacementPolicy splitPlacementPolicy = new BucketedSplitPlacementPolicy(nodeSelector, nodes, bucketNodeMap, stage::getAllTasks);
        ArrayList<SourceScheduler> sourceSchedulers = new ArrayList<SourceScheduler>();
        Preconditions.checkArgument((partitionHandles.equals(ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED)) != stageExecutionDescriptor.isStageGroupedExecution() ? 1 : 0) != 0, (Object)"PartitionHandles should be [NOT_PARTITIONED] if and only if all scan nodes use ungrouped execution strategy");
        int nodeCount = nodes.size();
        int concurrentLifespans = concurrentLifespansPerTask.isPresent() && concurrentLifespansPerTask.getAsInt() * nodeCount <= partitionHandles.size() ? concurrentLifespansPerTask.getAsInt() * nodeCount : partitionHandles.size();
        boolean firstPlanNode = true;
        Optional<Object> groupedLifespanScheduler = Optional.empty();
        for (PlanNodeId planNodeId : schedulingOrder) {
            SplitSource splitSource = splitSources.get(planNodeId);
            boolean groupedExecutionForScanNode = stageExecutionDescriptor.isScanGroupedExecution(planNodeId);
            SourceScheduler sourceScheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsSourceScheduler(stage, planNodeId, splitSource, splitPlacementPolicy, Math.max(splitBatchSize / concurrentLifespans, 1), groupedExecutionForScanNode);
            if (stageExecutionDescriptor.isStageGroupedExecution() && !groupedExecutionForScanNode) {
                sourceScheduler = new AsGroupedSourceScheduler(sourceScheduler);
            }
            sourceSchedulers.add(sourceScheduler);
            if (!firstPlanNode) continue;
            firstPlanNode = false;
            if (!stageExecutionDescriptor.isStageGroupedExecution()) {
                sourceScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
                continue;
            }
            LifespanScheduler lifespanScheduler = bucketNodeMap.isDynamic() ? new DynamicLifespanScheduler(bucketNodeMap, nodes, partitionHandles, concurrentLifespansPerTask) : new FixedLifespanScheduler(bucketNodeMap, partitionHandles, concurrentLifespansPerTask);
            lifespanScheduler.scheduleInitial(sourceScheduler);
            stage.addCompletedDriverGroupsChangedListener(lifespanScheduler::onLifespanExecutionFinished);
            groupedLifespanScheduler = Optional.of(lifespanScheduler);
        }
        this.groupedLifespanScheduler = groupedLifespanScheduler;
        this.sourceSchedulers = new CopyOnWriteArrayList<SourceScheduler>(sourceSchedulers);
    }

    private ConnectorPartitionHandle partitionHandleFor(Lifespan lifespan) {
        if (lifespan.isTaskWide()) {
            return NotPartitionedPartitionHandle.NOT_PARTITIONED;
        }
        return this.partitionHandles.get(lifespan.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleResult schedule() {
        Object newTasks = ImmutableList.of();
        if (!this.scheduledTasks) {
            newTasks = (List)Streams.mapWithIndex(this.nodes.stream(), (node, id) -> this.stage.scheduleTask((InternalNode)node, Math.toIntExact(id))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            this.scheduledTasks = true;
            this.stage.transitionToFinishedTaskScheduling();
        }
        boolean allBlocked = true;
        ArrayList<Object> blocked = new ArrayList<Object>();
        ScheduleResult.BlockedReason blockedReason = ScheduleResult.BlockedReason.NO_ACTIVE_DRIVER_GROUP;
        if (this.groupedLifespanScheduler.isPresent()) {
            while (!this.tasksToRecover.isEmpty()) {
                if (this.anySourceSchedulingFinished) {
                    throw new IllegalStateException("Recover after any source scheduling finished is not supported");
                }
                this.groupedLifespanScheduler.get().onTaskFailed(this.tasksToRecover.poll(), this.sourceSchedulers);
            }
            if (this.groupedLifespanScheduler.get().allLifespanExecutionFinished()) {
                for (SourceScheduler sourceScheduler : this.sourceSchedulers) {
                    sourceScheduler.notifyAllLifespansFinishedExecution();
                }
            } else {
                blocked.add(this.groupedLifespanScheduler.get().schedule(this.sourceSchedulers.get(0)));
            }
        }
        int splitsScheduled = 0;
        Iterator<SourceScheduler> schedulerIterator = this.sourceSchedulers.iterator();
        Object driverGroupsToStart = ImmutableList.of();
        while (schedulerIterator.hasNext()) {
            FixedSourcePartitionedScheduler fixedSourcePartitionedScheduler = this;
            synchronized (fixedSourcePartitionedScheduler) {
                if (this.closed) {
                    break;
                }
                SourceScheduler sourceScheduler = schedulerIterator.next();
                for (Lifespan lifespan : driverGroupsToStart) {
                    sourceScheduler.startLifespan(lifespan, this.partitionHandleFor(lifespan));
                }
                ScheduleResult schedule = sourceScheduler.schedule();
                if (schedule.getSplitsScheduled() > 0) {
                    this.stage.transitionToSchedulingSplits();
                }
                splitsScheduled += schedule.getSplitsScheduled();
                if (schedule.getBlockedReason().isPresent()) {
                    blocked.add(schedule.getBlocked());
                    blockedReason = blockedReason.combineWith(schedule.getBlockedReason().get());
                } else {
                    Verify.verify((boolean)schedule.getBlocked().isDone(), (String)"blockedReason not provided when scheduler is blocked", (Object[])new Object[0]);
                    allBlocked = false;
                }
                driverGroupsToStart = sourceScheduler.drainCompletelyScheduledLifespans();
                if (schedule.isFinished()) {
                    this.stage.schedulingComplete(sourceScheduler.getPlanNodeId());
                    this.sourceSchedulers.remove(sourceScheduler);
                    sourceScheduler.close();
                    this.anySourceSchedulingFinished = true;
                }
            }
        }
        if (allBlocked) {
            return ScheduleResult.blocked(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, MoreFutures.whenAnyComplete(blocked), blockedReason, splitsScheduled);
        }
        return ScheduleResult.nonBlocked(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, splitsScheduled);
    }

    public void recover(TaskId taskId) {
        this.tasksToRecover.add(taskId.getId());
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        for (SourceScheduler sourceScheduler : this.sourceSchedulers) {
            try {
                sourceScheduler.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        this.sourceSchedulers.clear();
    }

    private static class AsGroupedSourceScheduler
    implements SourceScheduler {
        private final SourceScheduler sourceScheduler;
        private boolean started;
        private boolean scheduleCompleted;
        private final List<Lifespan> pendingCompleted;

        public AsGroupedSourceScheduler(SourceScheduler sourceScheduler) {
            this.sourceScheduler = Objects.requireNonNull(sourceScheduler, "sourceScheduler is null");
            this.pendingCompleted = new ArrayList<Lifespan>();
        }

        @Override
        public ScheduleResult schedule() {
            return this.sourceScheduler.schedule();
        }

        @Override
        public void close() {
            this.sourceScheduler.close();
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.sourceScheduler.getPlanNodeId();
        }

        @Override
        public void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
            this.pendingCompleted.add(lifespan);
            if (this.started) {
                return;
            }
            this.started = true;
            this.sourceScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
        }

        @Override
        public void rewindLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
            throw new UnsupportedOperationException("rewindLifespan is not supported in AsGroupedSourceScheduler");
        }

        @Override
        public List<Lifespan> drainCompletelyScheduledLifespans() {
            if (!this.scheduleCompleted) {
                List<Lifespan> lifespans = this.sourceScheduler.drainCompletelyScheduledLifespans();
                if (lifespans.isEmpty()) {
                    return ImmutableList.of();
                }
                Preconditions.checkState((boolean)ImmutableList.of((Object)Lifespan.taskWide()).equals(lifespans));
                this.scheduleCompleted = true;
            }
            ImmutableList result = ImmutableList.copyOf(this.pendingCompleted);
            this.pendingCompleted.clear();
            return result;
        }

        @Override
        public void notifyAllLifespansFinishedExecution() {
            Preconditions.checkState((boolean)this.scheduleCompleted);
        }
    }

    public static class BucketedSplitPlacementPolicy
    implements SplitPlacementPolicy {
        private final NodeSelector nodeSelector;
        private final List<InternalNode> activeNodes;
        private final BucketNodeMap bucketNodeMap;
        private final Supplier<? extends List<RemoteTask>> remoteTasks;

        public BucketedSplitPlacementPolicy(NodeSelector nodeSelector, List<InternalNode> activeNodes, BucketNodeMap bucketNodeMap, Supplier<? extends List<RemoteTask>> remoteTasks) {
            this.nodeSelector = Objects.requireNonNull(nodeSelector, "nodeSelector is null");
            this.activeNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(activeNodes, "activeNodes is null"));
            this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
            this.remoteTasks = Objects.requireNonNull(remoteTasks, "remoteTasks is null");
        }

        @Override
        public SplitPlacementResult computeAssignments(Set<Split> splits) {
            return this.nodeSelector.computeAssignments(splits, this.remoteTasks.get(), this.bucketNodeMap);
        }

        @Override
        public void lockDownNodes() {
        }

        @Override
        public List<InternalNode> getActiveNodes() {
            return this.activeNodes;
        }

        public InternalNode getNodeForBucket(int bucketId) {
            return this.bucketNodeMap.getAssignedNode(bucketId).get();
        }
    }
}

