/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.spi.HostAddress;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class NetworkLocationCache {
    private static final Duration NEGATIVE_CACHE_DURATION = new Duration(10.0, TimeUnit.MINUTES);
    private static final Logger log = Logger.get(NetworkLocationCache.class);
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"network-location-%s"));
    private final NetworkTopology networkTopology;
    private final LoadingCache<HostAddress, NetworkLocation> cache;
    private final Cache<HostAddress, Boolean> negativeCache;

    public NetworkLocationCache(NetworkTopology networkTopology) {
        this.networkTopology = Objects.requireNonNull(networkTopology, "networkTopology is null");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).refreshAfterWrite(12L, TimeUnit.HOURS).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::locate), (Executor)this.executor));
        this.negativeCache = CacheBuilder.newBuilder().expireAfterWrite(NEGATIVE_CACHE_DURATION.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public NetworkLocation get(HostAddress host) {
        NetworkLocation location = (NetworkLocation)this.cache.getIfPresent((Object)host);
        if (location == null && this.negativeCache.getIfPresent((Object)host) == null) {
            this.cache.put((Object)host, (Object)NetworkLocation.ROOT_LOCATION);
            this.cache.refresh((Object)host);
        }
        return location == null ? NetworkLocation.ROOT_LOCATION : location;
    }

    private NetworkLocation locate(HostAddress host) {
        try {
            return this.networkTopology.locate(host);
        }
        catch (RuntimeException e) {
            this.negativeCache.put((Object)host, (Object)true);
            log.warn((Throwable)e, "Unable to determine location of %s. Will attempt again in %s", new Object[]{host, NEGATIVE_CACHE_DURATION});
            throw e;
        }
    }
}

