/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.scheduler.StageExecutionAndScheduler;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public class SectionExecution {
    private final StageExecutionAndScheduler rootStage;
    private final List<StageExecutionAndScheduler> allStages;
    @GuardedBy(value="this")
    private volatile boolean aborted;

    public SectionExecution(StageExecutionAndScheduler rootStage, List<StageExecutionAndScheduler> allStages) {
        this.rootStage = Objects.requireNonNull(rootStage, "rootStage is null");
        this.allStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(allStages, "allStages is null"));
    }

    public StageExecutionAndScheduler getRootStage() {
        return this.rootStage;
    }

    public List<StageExecutionAndScheduler> getSectionStages() {
        return this.allStages;
    }

    public boolean isFinished() {
        StageExecutionState rootStageState = this.rootStage.getStageExecution().getState();
        return rootStageState.isDone() && !rootStageState.isFailure();
    }

    public boolean isFailed() {
        StageExecutionState rootStageState = this.rootStage.getStageExecution().getState();
        return rootStageState.isFailure();
    }

    public boolean isRunning() {
        StageExecutionState rootStageState = this.rootStage.getStageExecution().getState();
        return !rootStageState.isDone() && rootStageState != StageExecutionState.PLANNED;
    }

    public synchronized boolean abort() {
        if (!this.aborted) {
            this.aborted = true;
            for (StageExecutionAndScheduler stageExecutionAndScheduler : this.allStages) {
                stageExecutionAndScheduler.getStageExecution().abort();
                stageExecutionAndScheduler.getStageScheduler().close();
            }
            return true;
        }
        return false;
    }
}

