/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Objects;
import java.util.OptionalInt;

@ThriftStruct
public class InternalNode
implements Node {
    private final String nodeIdentifier;
    private final URI internalUri;
    private final OptionalInt thriftPort;
    private final NodeVersion nodeVersion;
    private final boolean coordinator;
    private final boolean resourceManager;
    private final NodeStatus nodeStatus;

    public InternalNode(String nodeIdentifier, URI internalUri, NodeVersion nodeVersion, boolean coordinator) {
        this(nodeIdentifier, internalUri, nodeVersion, coordinator, false);
    }

    public InternalNode(String nodeIdentifier, URI internalUri, NodeVersion nodeVersion, boolean coordinator, boolean resourceManager) {
        this(nodeIdentifier, internalUri, OptionalInt.empty(), nodeVersion, coordinator, resourceManager, NodeStatus.ALIVE);
    }

    @ThriftConstructor
    public InternalNode(String nodeIdentifier, URI internalUri, OptionalInt thriftPort, String nodeVersion, boolean coordinator, boolean resourceManager) {
        this(nodeIdentifier, internalUri, thriftPort, new NodeVersion(nodeVersion), coordinator, resourceManager, NodeStatus.ALIVE);
    }

    public InternalNode(String nodeIdentifier, URI internalUri, OptionalInt thriftPort, NodeVersion nodeVersion, boolean coordinator, boolean resourceManager, NodeStatus nodeStatus) {
        nodeIdentifier = Strings.emptyToNull((String)Strings.nullToEmpty((String)nodeIdentifier).trim());
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null or empty");
        this.internalUri = Objects.requireNonNull(internalUri, "internalUri is null");
        this.thriftPort = Objects.requireNonNull(thriftPort, "thriftPort is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.coordinator = coordinator;
        this.resourceManager = resourceManager;
        this.nodeStatus = nodeStatus;
    }

    @ThriftField(value=1)
    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String getHost() {
        return this.internalUri.getHost();
    }

    @Deprecated
    public URI getHttpUri() {
        return this.getInternalUri();
    }

    @ThriftField(value=3)
    public OptionalInt getThriftPort() {
        return this.thriftPort;
    }

    @ThriftField(value=2, name="internalUri")
    public URI getInternalUri() {
        return this.internalUri;
    }

    public HostAddress getHostAndPort() {
        return HostAddress.fromUri((URI)this.internalUri);
    }

    @ThriftField(value=4, name="nodeVersion")
    public String getVersion() {
        return this.nodeVersion.getVersion();
    }

    @ThriftField(value=5)
    public boolean isCoordinator() {
        return this.coordinator;
    }

    @ThriftField(value=6)
    public boolean isResourceManager() {
        return this.resourceManager;
    }

    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    @ThriftField(value=7)
    public NodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InternalNode o = (InternalNode)obj;
        return this.nodeIdentifier.equals(o.nodeIdentifier);
    }

    public int hashCode() {
        return this.nodeIdentifier.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeIdentifier", (Object)this.nodeIdentifier).add("internalUri", (Object)this.internalUri).add("thriftPort", (Object)this.thriftPort).add("nodeVersion", (Object)this.nodeVersion).add("coordinator", this.coordinator).add("resourceManager", this.resourceManager).toString();
    }

    @ThriftEnum
    public static enum NodeStatus {
        ALIVE(1),
        DEAD(2);

        private final int statusCode;

        private NodeStatus(int statusCode) {
            this.statusCode = statusCode;
        }

        @ThriftEnumValue
        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

