/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;

public class FragmentCacheStats {
    private final AtomicLong hit = new AtomicLong();
    private final AtomicLong miss = new AtomicLong();
    private final AtomicLong inFlightBytes = new AtomicLong();
    private final AtomicLong cacheRemoval = new AtomicLong();
    private final AtomicLong cacheEntries = new AtomicLong();

    public void incrementCacheHit() {
        this.hit.getAndIncrement();
    }

    public void incrementCacheMiss() {
        this.miss.getAndIncrement();
    }

    public void addInFlightBytes(long bytes) {
        this.inFlightBytes.addAndGet(bytes);
    }

    public void incrementCacheRemoval() {
        this.cacheRemoval.getAndIncrement();
    }

    public void incrementCacheEntries() {
        this.cacheEntries.getAndIncrement();
    }

    public void decrementCacheEntries() {
        this.cacheEntries.getAndDecrement();
    }

    @Managed
    public long getCacheHit() {
        return this.hit.get();
    }

    @Managed
    public long getCacheMiss() {
        return this.miss.get();
    }

    @Managed
    public long getInFlightBytes() {
        return this.inFlightBytes.get();
    }

    @Managed
    public long getCacheRemoval() {
        return this.cacheRemoval.get();
    }

    @Managed
    public long getCacheEntries() {
        return this.cacheEntries.get();
    }
}

