/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.operator.LookupSource;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class JoinProbe {
    private final int[] probeOutputChannels;
    private final int positionCount;
    private final Block[] probeBlocks;
    private final Page page;
    private final Page probePage;
    private final Optional<Block> probeHashBlock;
    private int position = -1;

    private JoinProbe(int[] probeOutputChannels, Page page, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
        this.probeOutputChannels = probeOutputChannels;
        this.positionCount = page.getPositionCount();
        this.probeBlocks = new Block[probeJoinChannels.size()];
        for (int i = 0; i < probeJoinChannels.size(); ++i) {
            this.probeBlocks[i] = page.getBlock(probeJoinChannels.get(i).intValue());
        }
        this.page = page;
        this.probePage = new Page(page.getPositionCount(), this.probeBlocks);
        this.probeHashBlock = probeHashChannel.isPresent() ? Optional.of(page.getBlock(probeHashChannel.getAsInt())) : Optional.empty();
    }

    public int[] getOutputChannels() {
        return this.probeOutputChannels;
    }

    public boolean advanceNextPosition() {
        ++this.position;
        return this.position < this.positionCount;
    }

    public long getCurrentJoinPosition(LookupSource lookupSource) {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        if (this.probeHashBlock.isPresent()) {
            long rawHash = BigintType.BIGINT.getLong(this.probeHashBlock.get(), this.position);
            return lookupSource.getJoinPosition(this.position, this.probePage, this.page, rawHash);
        }
        return lookupSource.getJoinPosition(this.position, this.probePage, this.page);
    }

    public int getPosition() {
        return this.position;
    }

    public Page getPage() {
        return this.page;
    }

    private boolean currentRowContainsNull() {
        for (Block probeBlock : this.probeBlocks) {
            if (!probeBlock.isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    public static class JoinProbeFactory {
        private final int[] probeOutputChannels;
        private final List<Integer> probeJoinChannels;
        private final OptionalInt probeHashChannel;

        public JoinProbeFactory(int[] probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
            this.probeOutputChannels = probeOutputChannels;
            this.probeJoinChannels = probeJoinChannels;
            this.probeHashChannel = probeHashChannel;
        }

        public JoinProbe createJoinProbe(Page page) {
            return new JoinProbe(this.probeOutputChannels, page, this.probeJoinChannels, this.probeHashChannel);
        }
    }
}

