/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.Session;
import com.facebook.presto.array.AdaptiveLongBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.geospatial.GeometryUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.geospatial.rtree.Flatbush;
import com.facebook.presto.geospatial.rtree.HasExtent;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.PagesRTreeIndex;
import com.facebook.presto.operator.PagesSpatialIndex;
import com.facebook.presto.operator.SpatialIndexBuilderOperator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class PagesSpatialIndexSupplier
implements Supplier<PagesSpatialIndex> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PagesSpatialIndexSupplier.class).instanceSize();
    private static final int MEMORY_USAGE_UPDATE_INCREMENT_BYTES = 0x6400000;
    private final Session session;
    private final AdaptiveLongBigArray addresses;
    private final List<Type> types;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final Optional<Integer> radiusChannel;
    private final SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final Flatbush<PagesRTreeIndex.GeometryWithPosition> rtree;
    private final Map<Integer, Rectangle> partitions;
    private final long memorySizeInBytes;

    public PagesSpatialIndexSupplier(Session session, AdaptiveLongBigArray addresses, int positionCount, List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, int geometryChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Map<Integer, Rectangle> partitions, LocalMemoryContext localUserMemoryContext) {
        Objects.requireNonNull(localUserMemoryContext, "localUserMemoryContext is null");
        this.session = session;
        this.addresses = addresses;
        this.types = types;
        this.outputChannels = outputChannels;
        this.channels = channels;
        this.spatialRelationshipTest = spatialRelationshipTest;
        this.filterFunctionFactory = filterFunctionFactory;
        this.partitions = partitions;
        this.rtree = PagesSpatialIndexSupplier.buildRTree(addresses, positionCount, channels, geometryChannel, radiusChannel, partitionChannel, localUserMemoryContext);
        this.radiusChannel = radiusChannel;
        this.memorySizeInBytes = (long)INSTANCE_SIZE + this.rtree.getEstimatedSizeInBytes();
    }

    private static Flatbush<PagesRTreeIndex.GeometryWithPosition> buildRTree(AdaptiveLongBigArray addresses, int positionCount, List<List<Block>> channels, int geometryChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, LocalMemoryContext localUserMemoryContext) {
        Operator relateOperator = OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Relate);
        ObjectArrayList geometries = new ObjectArrayList();
        long recordedSizeInBytes = localUserMemoryContext.getBytes();
        long addedSizeInBytes = 0L;
        for (int position = 0; position < positionCount; ++position) {
            double radius;
            long pageAddress = addresses.get(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            Block block = channels.get(geometryChannel).get(blockIndex);
            if (block.isNull(blockPosition)) continue;
            Slice slice = block.getSlice(blockPosition, 0, block.getSliceLength(blockPosition));
            OGCGeometry ogcGeometry = EsriGeometrySerde.deserialize((Slice)slice);
            Verify.verify((ogcGeometry != null ? 1 : 0) != 0);
            if (ogcGeometry.isEmpty() || (radius = radiusChannel.map(channel -> DoubleType.DOUBLE.getDouble((Block)((List)channels.get((int)channel)).get(blockIndex), blockPosition)).orElse(0.0).doubleValue()) < 0.0) continue;
            if (!radiusChannel.isPresent()) {
                GeometryUtils.accelerateGeometry((OGCGeometry)ogcGeometry, (Operator)relateOperator);
            }
            int partition = -1;
            if (partitionChannel.isPresent()) {
                Block partitionBlock = channels.get(partitionChannel.get()).get(blockIndex);
                partition = Math.toIntExact(IntegerType.INTEGER.getLong(partitionBlock, blockPosition));
            }
            PagesRTreeIndex.GeometryWithPosition geometryWithPosition = new PagesRTreeIndex.GeometryWithPosition(ogcGeometry, partition, position, radius);
            geometries.add((Object)geometryWithPosition);
            if ((addedSizeInBytes += geometryWithPosition.getEstimatedSizeInBytes()) < 0x6400000L) continue;
            localUserMemoryContext.setBytes(recordedSizeInBytes + addedSizeInBytes);
            recordedSizeInBytes += addedSizeInBytes;
            addedSizeInBytes = 0L;
        }
        return new Flatbush((HasExtent[])geometries.toArray((Object[])new PagesRTreeIndex.GeometryWithPosition[0]));
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.memorySizeInBytes, DataSize.Unit.BYTE);
    }

    @Override
    public PagesSpatialIndex get() {
        if (this.rtree.isEmpty()) {
            return PagesSpatialIndex.EMPTY_INDEX;
        }
        return new PagesRTreeIndex(this.session, this.addresses, this.types, this.outputChannels, this.channels, this.rtree, this.radiusChannel, this.spatialRelationshipTest, this.filterFunctionFactory, this.partitions);
    }
}

