/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public class TaskExchangeClientManager {
    private final ExchangeClientSupplier supplier;
    @GuardedBy(value="this")
    private final List<ExchangeClient> exchangeClients;

    @VisibleForTesting
    public TaskExchangeClientManager(ExchangeClientSupplier supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
        this.exchangeClients = new ArrayList<ExchangeClient>();
    }

    public synchronized ExchangeClient createExchangeClient(LocalMemoryContext systemMemoryContext) {
        ExchangeClient exchangeClient = this.supplier.get(systemMemoryContext);
        this.exchangeClients.add(exchangeClient);
        return exchangeClient;
    }

    public synchronized List<ExchangeClient> getExchangeClients() {
        return ImmutableList.copyOf(this.exchangeClients);
    }
}

