/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.block.ArrayAllocator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UncheckedStackArrayAllocator
implements ArrayAllocator {
    private static final int DEFAULT_CAPACITY = 1000;
    private int[][] intArrays;
    private int intArraysTop = -1;
    private int borrowedIntArrays;
    private byte[][] byteArrays;
    private int byteArraysTop = -1;
    private int borrowedByteArrays;
    private long estimatedSizeInBytes;

    public UncheckedStackArrayAllocator() {
        this(1000);
    }

    public UncheckedStackArrayAllocator(int initialCapacity) {
        Preconditions.checkArgument((initialCapacity > 0 ? 1 : 0) != 0, (Object)"initialCapacity must be positive");
        this.intArrays = new int[initialCapacity][];
        this.byteArrays = new byte[initialCapacity][];
    }

    public int[] borrowIntArray(int positionCount) {
        int[] array;
        while (this.intArraysTop >= 0 && this.intArrays[this.intArraysTop].length < positionCount) {
            this.estimatedSizeInBytes -= SizeOf.sizeOfIntArray((int)this.intArrays[this.intArraysTop].length);
            this.intArrays[this.intArraysTop] = null;
            --this.intArraysTop;
        }
        if (this.intArraysTop < 0) {
            array = new int[positionCount];
            this.estimatedSizeInBytes += SizeOf.sizeOfIntArray((int)positionCount);
        } else {
            array = this.intArrays[this.intArraysTop];
            --this.intArraysTop;
        }
        ++this.borrowedIntArrays;
        return array;
    }

    public void returnArray(int[] array) {
        Objects.requireNonNull(array, "array is null");
        if (this.intArraysTop == this.intArrays.length - 1) {
            this.intArrays = (int[][])Arrays.copyOf(this.intArrays, this.intArrays.length * 2);
        }
        this.intArrays[++this.intArraysTop] = array;
        --this.borrowedIntArrays;
    }

    public byte[] borrowByteArray(int positionCount) {
        byte[] array;
        while (this.byteArraysTop >= 0 && this.byteArrays[this.byteArraysTop].length < positionCount) {
            this.estimatedSizeInBytes -= SizeOf.sizeOfByteArray((int)this.byteArrays[this.byteArraysTop].length);
            this.byteArrays[this.byteArraysTop] = null;
            --this.byteArraysTop;
        }
        if (this.byteArraysTop < 0) {
            array = new byte[positionCount];
            this.estimatedSizeInBytes += SizeOf.sizeOfByteArray((int)array.length);
        } else {
            array = this.byteArrays[this.byteArraysTop];
            --this.byteArraysTop;
        }
        ++this.borrowedByteArrays;
        return array;
    }

    public void returnArray(byte[] array) {
        Objects.requireNonNull(array, "array is null");
        if (this.byteArraysTop == this.byteArrays.length - 1) {
            this.byteArrays = (byte[][])Arrays.copyOf(this.byteArrays, this.byteArrays.length * 2);
        }
        this.byteArrays[++this.byteArraysTop] = array;
        --this.borrowedByteArrays;
    }

    public int getBorrowedArrayCount() {
        return this.borrowedIntArrays + this.borrowedByteArrays;
    }

    public long getEstimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("intArraysCapacity", this.intArrays.length).add("intArraysSize", this.intArraysTop).add("borrowedIntArraysSize", this.borrowedIntArrays).add("byteArraysCapacity", this.byteArrays.length).add("byteArraysSize", this.byteArraysTop).add("borrowedByteArraysSize", this.borrowedByteArrays).add("estimatedSizeInBytes", this.estimatedSizeInBytes).toString();
    }
}

