/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.BlockState;
import com.facebook.presto.operator.aggregation.state.BlockStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.SliceState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ReduceAggregationFunction
extends SqlAggregationFunction {
    private static final String NAME = "reduce_agg";
    private static final MethodHandle LONG_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableLongState.class, Object.class, Long.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle DOUBLE_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableDoubleState.class, Object.class, Double.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BOOLEAN_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableBooleanState.class, Object.class, Boolean.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle SLICE_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", SliceState.class, Object.class, Slice.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BLOCK_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", BlockState.class, Object.class, Block.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle LONG_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableLongState.class, NullableLongState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle DOUBLE_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableDoubleState.class, NullableDoubleState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BOOLEAN_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableBooleanState.class, NullableBooleanState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle SLICE_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", SliceState.class, SliceState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BLOCK_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", BlockState.class, BlockState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle LONG_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableLongState.class, "write", Type.class, NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableDoubleState.class, "write", Type.class, NullableDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableBooleanState.class, "write", Type.class, NullableBooleanState.class, BlockBuilder.class);
    private static final MethodHandle SLICE_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(SliceState.class, "write", Type.class, SliceState.class, BlockBuilder.class);
    private static final MethodHandle BLOCK_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(BlockState.class, "write", Type.class, BlockState.class, BlockBuilder.class);
    private final boolean supportsComplexTypes;

    public ReduceAggregationFunction(boolean supportsComplexTypes) {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T"), (Object)Signature.typeVariable((String)"S")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"S"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"S"), (Object)TypeSignature.parseTypeSignature((String)"function(S,T,S)"), (Object)TypeSignature.parseTypeSignature((String)"function(S,S,S)")));
        this.supportsComplexTypes = supportsComplexTypes;
    }

    public String getDescription() {
        return "Reduce input elements into a single value";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type inputType = boundVariables.getTypeVariable("T");
        Type stateType = boundVariables.getTypeVariable("S");
        return this.generateAggregation(inputType, stateType);
    }

    private InternalAggregationFunction generateAggregation(Type inputType, Type stateType) {
        AggregationMetadata.AccumulatorStateDescriptor stateDescriptor;
        MethodHandle outputMethodHandle;
        MethodHandle combineMethodHandle;
        MethodHandle inputMethodHandle;
        DynamicClassLoader classLoader = new DynamicClassLoader(ReduceAggregationFunction.class.getClassLoader());
        if (stateType.getJavaType() == Long.TYPE) {
            inputMethodHandle = LONG_STATE_INPUT_FUNCTION;
            combineMethodHandle = LONG_STATE_COMBINE_FUNCTION;
            outputMethodHandle = LONG_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableLongState.class, StateCompiler.generateStateSerializer(NullableLongState.class, classLoader), StateCompiler.generateStateFactory(NullableLongState.class, classLoader));
        } else if (stateType.getJavaType() == Double.TYPE) {
            inputMethodHandle = DOUBLE_STATE_INPUT_FUNCTION;
            combineMethodHandle = DOUBLE_STATE_COMBINE_FUNCTION;
            outputMethodHandle = DOUBLE_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableDoubleState.class, StateCompiler.generateStateSerializer(NullableDoubleState.class, classLoader), StateCompiler.generateStateFactory(NullableDoubleState.class, classLoader));
        } else if (stateType.getJavaType() == Boolean.TYPE) {
            inputMethodHandle = BOOLEAN_STATE_INPUT_FUNCTION;
            combineMethodHandle = BOOLEAN_STATE_COMBINE_FUNCTION;
            outputMethodHandle = BOOLEAN_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableBooleanState.class, StateCompiler.generateStateSerializer(NullableBooleanState.class, classLoader), StateCompiler.generateStateFactory(NullableBooleanState.class, classLoader));
        } else {
            if (!this.supportsComplexTypes) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("State type not enabled for %s: %s", NAME, stateType.getDisplayName()));
            }
            if (stateType.getJavaType() == Slice.class) {
                inputMethodHandle = SLICE_STATE_INPUT_FUNCTION;
                combineMethodHandle = SLICE_STATE_COMBINE_FUNCTION;
                outputMethodHandle = SLICE_STATE_OUTPUT_FUNCTION.bindTo(stateType);
                stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(SliceState.class, StateCompiler.generateStateSerializer(SliceState.class, classLoader), StateCompiler.generateStateFactory(SliceState.class, classLoader));
            } else if (stateType.getJavaType() == Block.class) {
                inputMethodHandle = BLOCK_STATE_INPUT_FUNCTION;
                combineMethodHandle = BLOCK_STATE_COMBINE_FUNCTION;
                outputMethodHandle = BLOCK_STATE_OUTPUT_FUNCTION.bindTo(stateType);
                stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(BlockState.class, new BlockStateSerializer(stateType), StateCompiler.generateStateFactory(BlockState.class, classLoader));
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unknown state java type: %s", stateType.getJavaType()));
            }
        }
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getNameSuffix(), inputType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)inputType.getTypeSignature())), ReduceAggregationFunction.createInputParameterMetadata(inputType, stateType), inputMethodHandle.asType(inputMethodHandle.type().changeParameterType(1, inputType.getJavaType())), combineMethodHandle, outputMethodHandle, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)stateDescriptor), inputType, (List<Class>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.getSignature().getNameSuffix(), (List<Type>)ImmutableList.of((Object)inputType), (List<Type>)ImmutableList.of((Object)stateType), stateType, true, false, factory, (List<Class>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type inputType, Type stateType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, inputType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, stateType));
    }

    public static void input(NullableLongState state, Object value, long initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(initialStateValue);
        }
        state.setLong((Long)inputFunction.apply(state.getLong(), value));
    }

    public static void input(NullableDoubleState state, Object value, double initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(initialStateValue);
        }
        state.setDouble((Double)inputFunction.apply(state.getDouble(), value));
    }

    public static void input(NullableBooleanState state, Object value, boolean initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(initialStateValue);
        }
        state.setBoolean((Boolean)inputFunction.apply(state.getBoolean(), value));
    }

    public static void input(SliceState state, Object value, Slice initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.getSlice() == null) {
            state.setSlice(initialStateValue);
        }
        state.setSlice((Slice)inputFunction.apply(state.getSlice(), value));
    }

    public static void input(BlockState state, Object value, Block initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.getBlock() == null) {
            state.setBlock(initialStateValue);
        }
        state.setBlock((Block)inputFunction.apply(state.getBlock(), value));
    }

    public static void combine(NullableLongState state, NullableLongState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong((Long)combineFunction.apply(state.getLong(), otherState.getLong()));
    }

    public static void combine(NullableDoubleState state, NullableDoubleState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        state.setDouble((Double)combineFunction.apply(state.getDouble(), otherState.getDouble()));
    }

    public static void combine(NullableBooleanState state, NullableBooleanState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(otherState.getBoolean());
            return;
        }
        state.setBoolean((Boolean)combineFunction.apply(state.getBoolean(), otherState.getBoolean()));
    }

    public static void combine(SliceState state, SliceState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.getSlice() == null) {
            state.setSlice(otherState.getSlice());
            return;
        }
        state.setSlice((Slice)combineFunction.apply(state.getSlice(), otherState.getSlice()));
    }

    public static void combine(BlockState state, BlockState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.getBlock() == null) {
            state.setBlock(otherState.getBlock());
            return;
        }
        state.setBlock((Block)combineFunction.apply(state.getBlock(), otherState.getBlock()));
    }
}

