/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.operator.aggregation.StatisticalDigest;
import com.facebook.presto.operator.aggregation.StatisticalDigestAggregationFunction;
import com.facebook.presto.operator.aggregation.StatisticalDigestFactory;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestState;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.tdigest.TDigest;
import com.facebook.presto.util.Failures;

public class TDigestAggregationFunction
extends StatisticalDigestAggregationFunction {
    public static final TDigestAggregationFunction TDIGEST_AGG = new TDigestAggregationFunction(TypeSignature.parseTypeSignature((String)"V"));
    public static final TDigestAggregationFunction TDIGEST_AGG_WITH_WEIGHT = new TDigestAggregationFunction(TypeSignature.parseTypeSignature((String)"V"), TypeSignature.parseTypeSignature((String)"bigint"));
    public static final TDigestAggregationFunction TDIGEST_AGG_WITH_WEIGHT_AND_COMPRESSION = new TDigestAggregationFunction(TypeSignature.parseTypeSignature((String)"V"), TypeSignature.parseTypeSignature((String)"bigint"), TypeSignature.parseTypeSignature((String)"double"));
    public static final String NAME = "tdigest_agg";

    private TDigestAggregationFunction(TypeSignature ... typeSignatures) {
        super(NAME, "tdigest", StatisticalDigestStateFactory.createTDigestFactory(), SqlFunctionVisibility.EXPERIMENTAL, typeSignatures);
    }

    public String getDescription() {
        return "Returns a tdigest from the set of doubles";
    }

    public static void inputDouble(StatisticalDigestState state, double value, long weight, double compression) {
        Failures.checkCondition(weight > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Weight must be > 0, was %s", weight);
        Failures.checkCondition(compression > 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Compression factor must be positive, was %s", compression);
        StatisticalDigest digest = TDigestAggregationFunction.getOrCreateTDigest(state, compression);
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    private static StatisticalDigest getOrCreateTDigest(StatisticalDigestState state, double compression) {
        StatisticalDigest digest = state.getStatisticalDigest();
        if (digest == null) {
            digest = StatisticalDigestFactory.createStatisticalTDigest(TDigest.createTDigest(compression));
            state.setStatisticalDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        return digest;
    }
}

