/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.builder;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TransformWork;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class InMemoryHashAggregationBuilder
implements HashAggregationBuilder {
    private final GroupByHash groupByHash;
    private final List<Aggregator> aggregators;
    private final OperatorContext operatorContext;
    private final boolean partial;
    private final OptionalLong maxPartialMemory;
    private final LocalMemoryContext systemMemoryContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final boolean useSystemMemory;
    private boolean full;

    public InMemoryHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, Optional<DataSize> maxPartialMemory, JoinCompiler joinCompiler, boolean yieldForMemoryReservation, boolean useSystemMemory) {
        this(accumulatorFactories, step, expectedGroups, groupByTypes, groupByChannels, hashChannel, operatorContext, maxPartialMemory, Optional.empty(), joinCompiler, yieldForMemoryReservation, useSystemMemory);
    }

    public InMemoryHashAggregationBuilder(List<AccumulatorFactory> accumulatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, Optional<DataSize> maxPartialMemory, Optional<Integer> overwriteIntermediateChannelOffset, JoinCompiler joinCompiler, boolean yieldForMemoryReservation, boolean useSystemMemory) {
        UpdateMemory updateMemory = yieldForMemoryReservation ? this::updateMemoryWithYieldInfo : () -> {
            this.updateMemoryWithYieldInfo();
            return true;
        };
        this.groupByHash = GroupByHash.createGroupByHash(groupByTypes, Ints.toArray(groupByChannels), hashChannel, expectedGroups, SystemSessionProperties.isDictionaryAggregationEnabled(operatorContext.getSession()), joinCompiler, updateMemory);
        this.operatorContext = operatorContext;
        this.partial = step.isOutputPartial();
        this.maxPartialMemory = maxPartialMemory.map(dataSize -> OptionalLong.of(dataSize.toBytes())).orElseGet(OptionalLong::empty);
        this.systemMemoryContext = operatorContext.newLocalSystemMemoryContext(InMemoryHashAggregationBuilder.class.getSimpleName());
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.useSystemMemory = useSystemMemory;
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        for (int i = 0; i < accumulatorFactories.size(); ++i) {
            AccumulatorFactory accumulatorFactory = accumulatorFactories.get(i);
            Optional<Object> overwriteIntermediateChannel = Optional.empty();
            if (overwriteIntermediateChannelOffset.isPresent()) {
                overwriteIntermediateChannel = Optional.of(overwriteIntermediateChannelOffset.get() + i);
            }
            builder.add((Object)new Aggregator(accumulatorFactory, step, overwriteIntermediateChannel, updateMemory));
        }
        this.aggregators = builder.build();
    }

    @Override
    public void close() {
        this.updateMemory(0L);
    }

    @Override
    public Work<?> processPage(Page page) {
        if (this.aggregators.isEmpty()) {
            return this.groupByHash.addPage(page);
        }
        return new TransformWork<GroupByIdBlock, Object>(this.groupByHash.getGroupIds(page), groupByIdBlock -> {
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage((GroupByIdBlock)groupByIdBlock, page);
            }
            return null;
        });
    }

    @Override
    public void updateMemory() {
        this.updateMemoryWithYieldInfo();
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public void recordHashCollisions(HashCollisionsCounter hashCollisionsCounter) {
        hashCollisionsCounter.recordHashCollision(this.groupByHash.getHashCollisions(), this.groupByHash.getExpectedHashCollisions());
    }

    public long getHashCollisions() {
        return this.groupByHash.getHashCollisions();
    }

    public double getExpectedHashCollisions() {
        return this.groupByHash.getExpectedHashCollisions();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        throw new UnsupportedOperationException("startMemoryRevoke not supported for InMemoryHashAggregationBuilder");
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException("finishMemoryRevoke not supported for InMemoryHashAggregationBuilder");
    }

    public long getSizeInMemory() {
        long sizeInMemory = this.groupByHash.getEstimatedSize();
        for (Aggregator aggregator : this.aggregators) {
            sizeInMemory += aggregator.getEstimatedSize();
        }
        return sizeInMemory;
    }

    public long getGroupIdsSortingSize() {
        return this.getGroupCount() * 4L;
    }

    public void setOutputPartial() {
        for (Aggregator aggregator : this.aggregators) {
            aggregator.setOutputPartial();
        }
    }

    public int getKeyChannels() {
        return this.groupByHash.getTypes().size();
    }

    public long getGroupCount() {
        return this.groupByHash.getGroupCount();
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        for (Aggregator aggregator : this.aggregators) {
            aggregator.prepareFinal();
        }
        return this.buildResult(this.consecutiveGroupIds());
    }

    public WorkProcessor<Page> buildHashSortedResult() {
        return this.buildResult(this.hashSortedGroupIds());
    }

    public List<Type> buildIntermediateTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
        for (Aggregator aggregator : this.aggregators) {
            types.add(aggregator.getIntermediateType());
        }
        return types;
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    private WorkProcessor<Page> buildResult(IntIterator groupIds) {
        PageBuilder pageBuilder = new PageBuilder(this.buildTypes());
        return WorkProcessor.create(() -> {
            if (!groupIds.hasNext()) {
                return WorkProcessor.ProcessState.finished();
            }
            pageBuilder.reset();
            List<Type> types = this.groupByHash.getTypes();
            while (!pageBuilder.isFull() && groupIds.hasNext()) {
                int groupId = groupIds.nextInt();
                this.groupByHash.appendValuesTo(groupId, pageBuilder, 0);
                pageBuilder.declarePosition();
                for (int i = 0; i < this.aggregators.size(); ++i) {
                    Aggregator aggregator = this.aggregators.get(i);
                    BlockBuilder output = pageBuilder.getBlockBuilder(types.size() + i);
                    aggregator.evaluate(groupId, output);
                }
            }
            return WorkProcessor.ProcessState.ofResult(pageBuilder.build());
        });
    }

    public List<Type> buildTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
        for (Aggregator aggregator : this.aggregators) {
            types.add(aggregator.getType());
        }
        return types;
    }

    private boolean updateMemoryWithYieldInfo() {
        long memorySize = this.getSizeInMemory();
        if (this.partial && this.maxPartialMemory.isPresent()) {
            this.updateMemory(memorySize);
            this.full = memorySize > this.maxPartialMemory.getAsLong();
            return true;
        }
        this.updateMemory(memorySize);
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    private void updateMemory(long memorySize) {
        if (this.useSystemMemory) {
            this.systemMemoryContext.setBytes(memorySize);
        } else {
            this.localUserMemoryContext.setBytes(memorySize);
        }
    }

    private IntIterator consecutiveGroupIds() {
        return IntIterators.fromTo((int)0, (int)this.groupByHash.getGroupCount());
    }

    private IntIterator hashSortedGroupIds() {
        final IntBigArray groupIds = new IntBigArray();
        groupIds.ensureCapacity((long)this.groupByHash.getGroupCount());
        for (int i = 0; i < this.groupByHash.getGroupCount(); ++i) {
            groupIds.set((long)i, i);
        }
        groupIds.sort(0, this.groupByHash.getGroupCount(), (leftGroupId, rightGroupId) -> Long.compare(this.groupByHash.getRawHash(leftGroupId), this.groupByHash.getRawHash(rightGroupId)));
        return new AbstractIntIterator(){
            private final int totalPositions;
            private int position;
            {
                this.totalPositions = InMemoryHashAggregationBuilder.this.groupByHash.getGroupCount();
            }

            public boolean hasNext() {
                return this.position < this.totalPositions;
            }

            public int nextInt() {
                return groupIds.get((long)this.position++);
            }
        };
    }

    public static List<Type> toTypes(List<? extends Type> groupByType, AggregationNode.Step step, List<AccumulatorFactory> factories, Optional<Integer> hashChannel) {
        ImmutableList.Builder types = ImmutableList.builder();
        types.addAll(groupByType);
        if (hashChannel.isPresent()) {
            types.add((Object)BigintType.BIGINT);
        }
        for (AccumulatorFactory factory : factories) {
            types.add((Object)new Aggregator(factory, step, Optional.empty(), UpdateMemory.NOOP).getType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final GroupedAccumulator aggregation;
        private AggregationNode.Step step;
        private final int intermediateChannel;

        private Aggregator(AccumulatorFactory accumulatorFactory, AggregationNode.Step step, Optional<Integer> overwriteIntermediateChannel, UpdateMemory updateMemory) {
            if (step.isInputRaw()) {
                this.intermediateChannel = -1;
                this.aggregation = accumulatorFactory.createGroupedAccumulator(updateMemory);
            } else if (overwriteIntermediateChannel.isPresent()) {
                this.intermediateChannel = overwriteIntermediateChannel.get();
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator(updateMemory);
            } else {
                Preconditions.checkArgument((accumulatorFactory.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
                this.intermediateChannel = accumulatorFactory.getInputChannels().get(0);
                this.aggregation = accumulatorFactory.createGroupedIntermediateAccumulator(updateMemory);
            }
            this.step = step;
        }

        public long getEstimatedSize() {
            return this.aggregation.getEstimatedSize();
        }

        public Type getType() {
            if (this.step.isOutputPartial()) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(GroupByIdBlock groupIds, Page page) {
            if (this.step.isInputRaw()) {
                this.aggregation.addInput(groupIds, page);
            } else {
                this.aggregation.addIntermediate(groupIds, page.getBlock(this.intermediateChannel));
            }
        }

        public void prepareFinal() {
            this.aggregation.prepareFinal();
        }

        public void evaluate(int groupId, BlockBuilder output) {
            if (this.step.isOutputPartial()) {
                this.aggregation.evaluateIntermediate(groupId, output);
            } else {
                this.aggregation.evaluateFinal(groupId, output);
            }
        }

        public void setOutputPartial() {
            this.step = AggregationNode.Step.partialOutput((AggregationNode.Step)this.step);
        }

        public Type getIntermediateType() {
            return this.aggregation.getIntermediateType();
        }
    }
}

